#ifndef _KBBOW_C_
#define _KBBOW_C_

#include "kbBow.h"
#include "kbNote.h"

KbBow::KbBow(KbNote * n, int l) : KbNoteExt(n), length(l) {}

KbBow::KbBow(KbNote * n, int l, int d) : KbNoteExt(n), length(l), dir(d) {}

KbBow::KbBow(KbNote * n, int l, int d, int dd) : KbNoteExt(n), length(l), dir(d), delta(dd) {}

void KbBow::flip() {
  if (dir==BowUp) dir = BowDown;
  else dir = BowUp;
}

int KbBow::gLength() { return length; }

int KbBow::gDir() { return dir; }

bool KbBow::isUp() { return (dir==BowUp); }

bool KbBow::isDown() { return (dir==BowDown); }

int KbBow::gDelta() { return delta; }

void KbBow::sLength(int l) { length = l; }

void KbBow::sDir(int i) { dir = i; }

void KbBow::sUp() { dir = BowUp; }

void KbBow::sDown() { dir = BowDown; }

void KbBow::sDelta(int i) { delta = i; }

/*KbNoteExt * KbBow::gNext() {
  KbNoteExt * e = next;
  for (;(e != 0) && (e->isBow()==false); e = e->next) {}
  return e;
  }*/

bool KbBow::isLyrics() { return false; }

bool KbBow::isStem() { return false; }

bool KbBow::isExp() { return false; }

bool KbBow::isBow() { return true; }


ostream & KbBow::print(ostream&s) {
  s << "<BOW length=\"" << length << "\" dir=\"" << dir << "\" delta=\"" << delta << "\" />" << endl;
}

KbNoteExt * KbBow::copy() {
  return new KbBow(note,length);
}

#endif
