#ifndef _POSITION_C_
#define _POSITION_C_

#include <iostream.h>
#include "kbPosition.h"

#include "kbTrack.h"
#include "kbPart.h"
#include "kbMasterEvent.h"

KbPosition::KbPosition() : totalTicks(0) {}

KbPosition::KbPosition(unsigned long p) : totalTicks(p) { if (p<0) totalTicks = -1; }

KbPosition::KbPosition(int p, int b, int t, KbPart * master,int m0, int m1) {
  set(p,b,t,master,m0,m1,0);
  if (totalTicks<0) totalTicks = -1;
}

KbPosition::KbPosition(int p, int b, int t, int m0, int m1) {
  set(p,b,t,0,m0,m1,0);
  if (totalTicks<0) totalTicks = -1;
}

unsigned long KbPosition::gPosTicks() {
  return totalTicks;
}

int KbPosition::gBar(KbPart * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);
  return bars;
}

int KbPosition::gBeat(KbPart * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);
  return beats;
}

int KbPosition::gTicks(KbPart * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);
  return ticks;
}

int KbPosition::gBar(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return bars;
}

int KbPosition::gBeat(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return beats;
}

int KbPosition::gTicks(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return ticks;
}

int KbPosition::gBar(KbPart * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return bars;
}

int KbPosition::gBeat(KbPart * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return beats;
}

int KbPosition::gTicks(KbPart * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return ticks;
}

void KbPosition::gBBT(int & bars, int & beats, int & ticks, KbPart * master, int & mm0, int & mm1, bool returnMeter) {
  int retv = 0;
  int m0 = mm0;
  int m1 = mm1;
  double timeF;
  int ticksPerBar;
  int ticksPerBeat;
  int timeWI;
  if (master) {
    m0 = Meter(0,master);
    m1 = Meter(1,master);
    KbPosition mOff = master->gOffset(); //1536*master->gTime1()/master->gTime2()*(master->gFrom());
    KbPosition pPos = 0;
    KbPosition deltaPos = 0;
    KbPosition mePos = 0;
    ticks = 0;
    beats = 0;
    bars = 0;
    KbMasterEvent * me = 0;
    me = master->gFirstMasterEvent();
    while ((me!=0) && (me->gPos()+mOff<totalTicks)) {
      if (me->gTempo()==0) {
	mePos = me->gPos()+mOff;
	if (mePos==mOff) {
	} else {
	  deltaPos = mePos-pPos;
	  timeF = 1.0*m0/m1;
	  ticksPerBar = int(timeF*1536);
	  ticksPerBeat = ticksPerBar/m0;
	  timeWI = deltaPos.modulo(ticksPerBar);
	  ticks += deltaPos.modulo(ticksPerBeat);
	  beats += (timeWI-(deltaPos.modulo(ticksPerBeat)))/ticksPerBeat;
	  bars += (deltaPos-timeWI)/ticksPerBar;
	}
	m0 = me->gMeter0();
	m1 = me->gMeter1();
	pPos = mePos;
      }
      me = (KbMasterEvent*) me->gNext();
    }

    deltaPos = totalTicks-pPos;
    // cout << "ok: " << deltaPos.gPosTicks() << endl;
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    timeWI = deltaPos.modulo(ticksPerBar);
    ticks += deltaPos.modulo(ticksPerBeat);
    beats += (timeWI-(deltaPos.modulo(ticksPerBeat)))/ticksPerBeat;
    bars += (deltaPos-timeWI)/ticksPerBar;
    bars++; beats++;
    if (returnMeter) {
      mm0 = m0;
      mm1 = m1;
    }
  } else {
    timeF = 1.0*m0/m1;
    if (timeF==0) cerr << "PANIC: BBT" << endl;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    timeWI = totalTicks%ticksPerBar;
    ticks = totalTicks%ticksPerBeat;
    beats = (timeWI-ticks)/ticksPerBeat+1;
    bars = (totalTicks-timeWI)/ticksPerBar+1;
  }
}    

void KbPosition::nextBar(KbPart * master,int met0, int met1) {
  if (master!=0) {
    met0 = Meter(0,master);
    met1 = Meter(1,master);
    KbPosition mOff = master->gOffset();
    KbPosition mePos = mOff;

    KbPosition pPos = mOff;
    KbMasterEvent * me = master->gFirstMasterEvent();
    KbMasterEvent * meOld = 0;
    
    bool loop = true;
    while (me!=0 && loop) {
      if ( me->gTempo() == 0 ) {
	mePos = me->gPos() + mOff;
	if (mePos>totalTicks) loop = false;
	else meOld = me;
      }
      me = (KbMasterEvent*) me->gNext();
    }
    if (meOld==0) totalTicks += 1536.0*met0/met1;
    else totalTicks += 1536.0*meOld->gMeter0()/meOld->gMeter1();
  } else {
    totalTicks += 1536.0*met0/met1;
  }
}
  
void KbPosition::snap(int s) {
  totalTicks += int(s*0.5);
  totalTicks = totalTicks - (totalTicks%s);
}

KbPosition & KbPosition::operator=(const KbPosition & p) {
  totalTicks = p.totalTicks;
  return *this;
}

KbPosition & KbPosition::operator=(unsigned long i) {
  totalTicks = i;
  return *this;
}

KbPosition & KbPosition::set(int p, int b, int t, KbPart * master, int mm0, int mm1, int snap) {
  totalTicks = 0;
  int m0 = mm0;
  int m1 = mm1;
  double timeF;
  int ticksPerBar;
  int ticksPerBeat;
  int timeWI;
  p--; b--;
  if (master!=0) {
    m0 = Meter(0,master);
    m1 = Meter(1,master);
    // cout  << "meter: " << m0 << ", " << m1 << endl;
    KbPosition mOff = master->gOffset(); //1536*master->gTime1()/master->gTime2()*(master->gFrom());
    KbPosition mePos = mOff;
    KbPosition pPos = mOff;
    KbPosition deltaPos;
    KbMasterEvent * me = master->gFirstMasterEvent();
    int meBars;
    int meBeats;
    int meTicks;

    bool loop = true;
    while (me!=0 && loop) {
      if ( me->gTempo() == 0 ) {
	mePos = me->gPos() + mOff;
	mePos.gBBT(meBars,meBeats,meTicks,master,m0,m1); // m0 und m1 added 15.8.99
	meBars--; meBeats--;
	if ( ( p <  meBars) ||
	       ((p == meBars) && (b <  meBeats)) ||
	       ((p == meBars) && (b == meBeats) && (t < meTicks))) { // ARG < mePos
	  loop = false;
	} else {
	  m0 = me->gMeter0();
	  m1 = me->gMeter1();
	  pPos = mePos;
	}
      }
      me = (KbMasterEvent*) me->gNext();
    }
    // cout << "ok: " << p << "." << b << "." << t << ",  " << pPos.gPosTicks() << ": " << pPos.gBar(master) << endl;
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    totalTicks = pPos.gPosTicks();
    t = t - pPos.gTicks(master); if (t < 0) { b--; t += ticksPerBeat; }
    b = b - (pPos.gBeat(master)-1);  if (b < 0) { p--; b += m0; } // m0 = beats per Bar
    p = p - (pPos.gBar(master)-1);
    if (p < 0) { printf("something wrong in KbPosition constructor!"); }
    totalTicks += (p*ticksPerBar + b*ticksPerBeat + t);
  } else {
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    // deltaPos = mePos-pPos;
    // timeWI = deltaPos.modulo(ticksPerBar);
    totalTicks += (p*ticksPerBar + b*ticksPerBeat + t);
  }
  if (snap!=0) totalTicks = totalTicks - (totalTicks%snap);
  // cout << "tt" << totalTicks << endl;
  return *this;
}

KbPosition & KbPosition::operator+=(KbPosition p) {
  totalTicks += p.totalTicks;
  return *this;
}

KbPosition & KbPosition::operator-=(KbPosition p) {
 totalTicks -= p.totalTicks;
 return *this;
}

double KbPosition::operator*(double d) {
  return totalTicks*1.0*d;
}

KbPosition operator+(KbPosition p1,KbPosition p2) {
  return KbPosition(p1.totalTicks+p2.totalTicks);
}

KbPosition operator-(KbPosition p1,KbPosition p2) {
  return KbPosition(p1.totalTicks-p2.totalTicks);
}

unsigned long operator+(KbPosition p,unsigned long i) {
  return p.totalTicks+i;
}

unsigned long operator-(KbPosition p,unsigned long i) {
  return p.totalTicks-i;
}

bool operator==(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks==p2.totalTicks) return true;
  else return false;
}

bool operator==(KbPosition p1,unsigned long lp2) {
  if (p1.totalTicks==lp2) return true;
  else return false;
}

bool operator!=(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks!=p2.totalTicks) return true;
  else return false;
}

bool operator!=(KbPosition p1,unsigned long lp2) {
  if (p1.totalTicks!=lp2) return true;
  else return false;
}

bool operator<(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks<p2.totalTicks) return true;
  else return false;
}

bool operator>(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks>p2.totalTicks) return true;
  else return false;
}

bool operator<=(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks<=p2.totalTicks) return true;
  else return false;
}

bool operator>=(KbPosition p1,KbPosition p2) {
  if (p1.totalTicks>=p2.totalTicks) return true;
  else return false;
}


KbPosition & operator++(KbPosition & p,int) { p.totalTicks++; return p; }

ostream & operator<<(ostream & s,KbPosition & p) {
  s << p.totalTicks;
  return s;
}


// for internal use only:

int KbPosition::modulo(int m) {
  return totalTicks%m;
}

int KbPosition::Meter(int m,KbPart * master) {
  // This returns the numerator for m=0 and the nominator for m=1 (already powered!)
  return master->gTrack()->gMain()->gMeter(m);
}

#endif
