#ifndef _KBTRACK_C_
#define _KBTRACK_C_

#include "kbTrack.h"
#include "kbPart.h"
#include <iostream.h>
#include <string.h>

KbTrack::KbTrack( KbMain * kbMain, int i )
  : main(kbMain), part(0), next(0), type(i)
{
  sName(" - ");
  for (int i=0;i<2;i++) toggle[i] = false;
  //ifTrack = kbMain->gFactory()->createTrack(this);
}

KbTrack::~KbTrack() {
  KbPart * p;
  KbPart * p1;
  p = part;
  while (p!=0) {
    if (p->gNext()==0) { delete p; p = 0; }
    else { p1 = p; p = p->gNext(); delete p1; }
  }
  part = 0;
  gInterface()->erase();
}

KbTrack * KbTrack::gNext() {
  return next;
}

void KbTrack::sNext(KbTrack * tr) {
  next = tr;
}

KbMain * KbTrack::gMain() {
  return main;
}

int KbTrack::trackNum() {
  int n=0;
  KbTrack * tr = main->gTrack();
  while (tr!=0 && tr!=this) {
    n++;
    tr = tr->gNext();
  }
  return n;
}

IfTrack * KbTrack::gInterface() { return ifTrack; }

KbPart * KbTrack::gPart() { return part; }

bool KbTrack::gToggle(int i) { return toggle[i]; }

void KbTrack::sToggle(int i, bool n) { toggle[i] = n; }

void KbTrack::sPart(KbPart * p) { part = p; }

KbPart * KbTrack::addPart(KbPosition os) {
  KbPart * p = new KbPart(this,os);
  return p;
}

void KbTrack::setPart(KbPart * p) {
  part = p;
  p->setTrack(this);
}

char * KbTrack::gName() { return name; }

void KbTrack::sName(char * n) {
  if (n!=0) sprintf(name,"%s\0",n);
}

int KbTrack::isA() {
  return type;
}

#endif
