#ifndef _KBPARTEXTENSION_H_
#define _KBPARTEXTENSION_H_

class KbPart;
class KbPartExtension;

class KbExtensionManager
{
 private:
  KbPartExtension * ext;
  KbPartExtension * cur;

 public:
  /**
   * one object of the KbExtensionManager is created in KbMain. This constructor
   * holds the definitions for all extensions. Please add your extensions in this
   * constructor in kbPartExtension.C
   */
  KbExtensionManager();

  /**
   * use this method to add an extension (see kbPartExtension.C)
   */
  void addExtension(KbPartExtension * e);

  /**
   * initialize before going through the extensions list. This is done in
   * qtPart.C, you dont need to call this yourself.
   */
  void init();

  /**
   * gets the extension i, or the current extension if i is -1. This is done in
   * qtPart.C, you dont need to call this yourself.
   */ 
  KbPartExtension * getExtension(int i=-1);

  /**
   * increments the pointer to the current extension.  This is done in
   * qtPart.C, you dont need to call this yourself.
   */
  void incr();
};

/**
 * This is the base class for all extensions. Derive from KbPartExtension and override the
 * act-method. From your constructor call KbPartExtensions constructor with your
 * extensions name as a parameter. This will then appear in the popup menu
 * under "userdefined functions"
 */
class KbPartExtension
{
 private:
  char * myName;
  KbPartExtension * next;

 public:
  /**
   * call this constructor from your constructor with your extensions name as a parameter
   */
  KbPartExtension(char * n);

  /**
   * returns the extensions name
   */
  char * name();

  /**
   * sets the next extension in the list
   */
  void sNext(KbPartExtension * e);

  /**
   * gets the next extension in the list, or zero if there is no further extension
   */
  KbPartExtension * gNext();

  /**
   * override this method to provide your funtionality
   */
  virtual void act(KbPart * p);
};



#endif
