#ifndef _QTEDITOR_H_
#define _QTEDITOR_H_

#include "qtMain.h"
#include "ifEditor.h"
#include "qtSelFrame.h"
#include "kbPosition.h"

#include <qaccel.h>
#include <qcolor.h>

class KbPart;
class KbNote;
class KbAtom;

/**
 * This class contains the basic functionality of a qt editor. Concrete editors like ScoreEditor, DrumEditor
 * and PianoRollEditor are derived from this.
 * @short Qt Editor
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtEditor : public KTopLevelWidget, public IfEditor
{
  Q_OBJECT
 private:
  char * author;
 protected:
  bool allParts;
  int snapValue;
  int velocValue;
  int lenValue;
  bool triValue;
  bool dotValue;
  bool speaker;
  bool colorchan;

  QPopupMenu * selection;
  QPopupMenu * options;
  QPopupMenu * snap;
  QPopupMenu * veloc;
  QPopupMenu * rbmenu;
  KMenuBar * menu;
  KToolBar * panel;
  Notebar * notebar;
  QtSelFrame * selFrame;
  QLineEdit * insLine;

  KbPart * part;
  KbPart * partList[128];
  int parts;
  KbMain * main;
  double pixPerTick;
  int xmOffset;
  KbPosition posLeft;
  KbPosition posRight;
  int xoffset;
  int yoffset;

  KbPart * master;
  int met0;
  int met1;

  KbPosition pos;
  int volGrabX1;
  int volGrabX2;
  int volGrabY1;
  int volGrabY2;
  int yGrab;

  bool createNote;
  int mouseX;
  int mouseY;
  KbPosition mousePos;
  int mouseDownX;
  int mouseDownY;
  KbPosition mouseDownPos;
  int mouseRelX;
  int mouseRelY;
  KbPosition mouseRelPos;

  KbPosition selX1;
  KbPosition selX2;
  KbPosition grabPos;
  KbAtom * grabNote;
  KbAtom * selNote;
  KbAtom * noteSelection;
  int grabX1;
  int grabX2;
  int grabY1;
  int grabY2;
  bool shftFlag;
  bool ctrlFlag;
  KbPosition insPtr;

  void getPartInfo();
  // int timeOfMouse(int mPos);
  KbPosition mousePosition();
  KbPosition mouseDownPosition();
  KbPosition position(int);
  int ticksOfLen(int cl);
  void showNoteInfo();
  void showNoteInfoOff();
  void setIns(KbPosition);
  virtual void showFreq();
  virtual int Pitch(int)=0;

  void transposeSystem();
  void deleteBuffer();
  void unmarkSelection();
  void transposeSelection();
  void clearSelection();
  void cutSelection();
  void copySelection();
  void pasteSelection();
  void enableSelItems(bool);

  int selSystem;
  QColor chancolor[16];

 public:

  /**
   * Constructor. Call this constructor from your editors constructor with the following arguments:
   * @param name the name of your editor, which just appears in the window titlebar of your editor.
   * @param kbpart the part that shall be displayed in your editor (you usually have this as a parameter for your constructor)
   * @param author your name: It appears in the editors about box of the optionmenu ;-)
   * @param all if this is true, the variable partList is filled with all parts (but the muted), (the score editor makes use of this)
   */
  QtEditor(char * name, KbPart * kbpart, char * author, bool all=false);

  ~QtEditor();

  /**
   * Initialization of the fundamental editor attributes. Call this from your constructor as well.
   */
  void init();

  /**
   * returns the current editor setting of the length value. (You have to provide a way to change this value yourself.
   * E.g. in the score-editor I provide a buttonbar the user can select the length value from, the default value is 4).
   * You can use any types of values, even midi-ticks. The score-editor uses different codings: A length value of 1
   * represents 1536 midi-ticks (a whole note), a length value of 2 represents 768 midi-ticks (a half note), 3 is 384 midi-ticks
   * (a quarter), 4 is 192 midi-ticks (an eigth note), 5 is 96 midi-ticks (a sixteenth note), etc.
   * There are additional methods for triplets and dotted notes (see below).
   * @see #sLenValue
   * @see #gDotValue
   * @see #sDotValue
   * @see #gTriValue
   * @see #sTriValue
   */
  int gLenValue();

  /**
   * sets the length value
   * @see #gLenValue
   * @see #gDotValue
   * @see #sDotValue
   * @see #gTriValue
   * @see #sTriValue
   */
  void sLenValue(int l);

  /**
   * returns the dot value.
   * @see #gLenValue
   * @see #sLenValue
   * @see #sDotValue
   * @see #gTriValue
   * @see #sTriValue
   */
  bool gDotValue();

  /**
   * sets the dot value
   * @see #gLenValue
   * @see #sLenValue
   * @see #gDotValue
   * @see #gTriValue
   * @see #sTriValue
   */
  void sDotValue(bool d);

  /** returns the triplet value
   * @see #gLenValue
   * @see #sLenValue
   * @see #gDotValue
   * @see #sDotValue
   * @see #sTriValue
   */
  bool gTriValue();

  /**
   * sets the triplet value
   * @see #gLenValue
   * @see #sLenValue
   * @see #gDotValue
   * @see #gTriValue
   * @see #gTriValue
   */
  void sTriValue(bool t);

  /**
   * override this method to add extra functionality to the options menu of your editor
   */
  virtual void addOptions();

  /**
   * override this method to add extra functionality to the right mouse button menu
   */
  virtual void addMenuEntries();

  /**
   * override this method. It is called when the user selects the "settings" entry of the "System" menu.
   * (E.g. the score editorcalls the key-clef-and-meter chooser).
   */
  virtual void settings();

  /**
   * If a note is selected, this returns the notes address
   */
  KbAtom * selectedNote();

  /**
   * sets the selected Note
   */
  void selectNote(KbAtom * n);

  /**
   * returns the part under consideration
   */
  KbPart * gPart();

  /**
   * if there exists a note at position pos and pitch freq, grab it!
   */
  void getGrabNote(KbPosition pos, int freq);


 public slots:
  
  /**
   * override this method to get your own presentation of the part.
   */
  virtual void paintEvent( QPaintEvent * );

 /**
  * resize event
  */
  virtual void resizeEvent( QResizeEvent * );

  /**
   * This is called when an entry of the file menu is selected.
   */
  void fileMenu(int);

  /**
   * This is called when an entry of the system menu is selected.
   */
  void systemMenu(int);

  /**
   * This is called when an entry of the selection menu is selected.
   */
  void selectionMenu(int);

  /**
   * Override this method if you have declared any entries for the options menu.
   * This is called when an entry of the options menu is selected.
   */
  virtual void optionsMenu(int);

  /**
   * This is called when an entry of the snap menu is selected.
   */
  void snapMenu(int);

  /**
   * This is called when an entry of the velocity menu is selected.
   */
  void velocMenu(int);

  /**
   * This is called when an button of the panel is pressed.
   */
  void panelMenu(int);

  /**
   * This is called when a new position is entered in the "insert" text field.
   */
  void setIns();

  void deleteNote();

  void glueNote();

  /**
   *
   */
  // int gLeftDelta();

  /**
   * override this method to let your editor react on mouse press events
   */
  virtual void mousePressEvent ( QMouseEvent * );

  /**
   * override this method to let your editor react on mouse move events
   */
  virtual void mouseMoveEvent  ( QMouseEvent * );

  /**
   * override this method to let your editor react on mouse release events
   */
  virtual void mouseReleaseEvent ( QMouseEvent * );

  /**
   * override this method to let your editor react on key press events
   */
  virtual void keyPressEvent ( QKeyEvent * );

  /**
   * override this method to let your editor react on key release events
   */
  virtual void keyReleaseEvent ( QKeyEvent * );


};


#endif
