#ifndef _QTKEYCHOOSER_C_
#define _QTKEYCHOOSER_C_

#include "qtKeyChooser.h"
#include "kbPart.h"
#include "qtScore.h"

extern int sharpTab[];
extern int signShift[];
extern int flatTab[];

QtChooser::QtChooser( KbPart * p, QtScore * s )
  : QLabel(0,"Chooser",WStyle_Customize | WStyle_DialogBorder), part(p),
    key(p->gKey()), clef(p->gClef()), time1(p->gTime1()), time2(p->gTime2()), score(s)
{
  setCaption("Chooser");

  KIconLoader *loader = kapp->getIconLoader();

  setBackgroundMode( PaletteLight );
  setFixedSize(195,80);
  QPushButton * clefU = new QPushButton( this ); clefU->setPixmap( loader->loadIcon("up.xpm") ); clefU->setGeometry(0,0,20,30);
  QPushButton * clefD = new QPushButton( this ); clefD->setPixmap( loader->loadIcon("down.xpm") ); clefD->setGeometry(0,30,20,30);
  QPushButton * keyU = new QPushButton( this ); keyU->setPixmap( loader->loadIcon("up.xpm") ); keyU->setGeometry(150,0,20,30);
  QPushButton * keyD = new QPushButton( this ); keyD->setPixmap( loader->loadIcon("down.xpm") ); keyD->setGeometry(150,30,20,30);
  QSpinBox * num = new QSpinBox( 1,20,1,this ); num->setGeometry(170,0,25,30); num->setValue(time1);
  QSpinBox * nom = new QSpinBox( 1,5,1,this ); nom->setGeometry(170,30,25,30); nom->setValue(time2);
  QPushButton * ok = new QPushButton( this ); ok->setPixmap( loader->loadIcon("exit.xpm") ); ok->setGeometry(0,60,195,20);

  connect(clefU,SIGNAL(pressed()),SLOT(incClef()));
  connect(clefD,SIGNAL(pressed()),SLOT(decClef()));
  connect(keyU,SIGNAL(pressed()),SLOT(incKey()));
  connect(keyD,SIGNAL(pressed()),SLOT(decKey()));
  connect(num,SIGNAL(valueChanged(int)),SLOT(updateNum(int)));
  connect(nom,SIGNAL(valueChanged(int)),SLOT(updateNom(int)));
  connect(ok,SIGNAL(pressed()),SLOT(ok()));

  clefU->show(); clefD->show(); keyU->show(); keyD->show(); ok->show();

}


void QtChooser::paintEvent ( QPaintEvent * pe ) {
  sprintf(t1, "%d\0", time1);
  sprintf(t2, "%d\0", int(time2));
  QPainter painter;
  painter.begin(this);
  if (score!=0) {
    painter.drawPixmap(28,12,score->imgClef[clef]); // draw Clef
    painter.drawLine(28,20,28,44);
    painter.drawLine(140,20,140,44);
    for (int i=0;i<5;i++)
      painter.drawLine(28,20+i*6,150,20+i*6);
    
    int nKey = abs(key);
    for (int i=0; i<nKey; i++) {
      if (key>0) { painter.drawPixmap(75+i*6-8,20+sharpTab[i]+signShift[clef]-12,score->imgSharp); // draw sharps
      } else { painter.drawPixmap(75+i*6-8,20+flatTab[i]+signShift[clef]-2-9,score->imgFlat);      // draw flats
      }
    }
    painter.setFont(QFont("Helvetica",12,QFont::Bold));
    painter.drawText(125,31,t1);  // draw measurement
    painter.drawText(125,43,t2); 
  }
  painter.end();
  
}

void QtChooser::incClef() {
  clef++;
  if (clef==14) clef=0;
  repaint();
}

void QtChooser::decClef() {
  clef--;
  if (clef==-1) clef=13;
  repaint();
}

void QtChooser::incKey() {
  key++;
  if (key==8) key=-7;
  repaint();
}

void QtChooser::decKey() {
  key--;
  if (key==-8) key=7;
  repaint();
}

void QtChooser::ok() {
  part->sKey(key);
  part->sClef(clef);
  part->sTime1(time1);
  part->sTime2(time2);
  //scanvas->scrKey = key);
  //scanvas->clef = clef);
  score->repaint();
  delete this;
}

void QtChooser::updateNum(int n) {
  time1=n;
  repaint();
}

void QtChooser::updateNom(int n) {
  time2=n;
  repaint();
}


#endif
