#ifndef _QTMAIN_H_
#define _QTMAIN_H_


#include <qpainter.h>
#include <qbitmap.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qtimer.h>
#include <qdatetm.h>
#include <qscrollview.h>
#include <qsplitter.h>
#include <qspinbox.h>
#include <qtabdialog.h>
#include <qgroupbox.h>
#include <qprogressbar.h>
#include <qslider.h>
#include <qlabel.h>
#include <qpopmenu.h>
#include <qspinbox.h>
#include <qprogressbar.h>
#include <qfiledlg.h>
#include <kmenubar.h>
#include <klocale.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kurl.h>
#include <kspinbox.h>
#include <kslider.h>

#include "ifMain.h"
#include "kbMain.h"
#include "qtPrefs.h"


class KbMain;
class QtHeadLine;
class QtPartCanvas;
class QtPrefs;
class QtSelFrame;

class MySpinBox : public QSpinBox
{
 Q_OBJECT
 public:
  MySpinBox ( QWidget * parent = 0, const char * name = 0 );
  MySpinBox ( int minValue, int maxValue, int step = 1, QWidget * parent = 0, const char * name = 0 );
 public slots:
  void focusInEvent ( QFocusEvent * );
  void focusOutEvent ( QFocusEvent * );
};

/**
 * main presentation (and visualization) of the Brahms main object.
 * @short main presentation (and visualization) of the Brahms main object.
 * @version 0.95
 * @author Jan Wuerthner
 */
class QtMain : public KTopLevelWidget, public IfMain
{
  Q_OBJECT
 private:
  char bufCtoP[CMDLENCTOP + 1];
  ssize_t ctop_read;
  int led[128];

  KDNDDropZone * dropZone1;
  KDNDDropZone * dropZone2;
  QString posString;
  QStrList * devList;
  KApplication * kooBase;
  KbMain * main;
  KMenuBar * menu;
  KToolBar * toolbar;
  KToolBar * panel;
  QtHeadLine * headline;
  QPopupMenu * snapm;
  //QLineEdit * pos;
  QSlider * posSlider;
  QLabel * tempolab;
  QLabel * meterlab1;
  QLabel * meterlab2;
  // KNumericSpinBox * tempobox;
  MySpinBox * tempobox;
  MySpinBox * meterbox1;
  MySpinBox * meterbox2;
  QProgressBar * progressbar;
  KStatusBar * stat;
  QScrollView * scroller;
  QSplitter * splitter;
  QtPartCanvas * pcanvas;
  int trackWidth;
  int trackHeight;
  int pcBarOff;
  double pixPerTick;
  QWidget * left; 
  QtSelFrame * selFrame;

  char * midiLoadDialog(QString *);
  ifstream * kbLoadDialog(QString *);
  ofstream * midiSaveDialog(QString *);
  ofstream * kbSaveDialog(QString *);

  int answer;
  int count;
  int numScr;

  void newScore();
  void mixdown();

  QtPrefs * PREFS;

  int partShow;

 protected:
  
  void timerEvent( QTimerEvent * e );

 public:

  QTimer * timer;

  /**
   * Constructor for the presentation of the main Brahms object.
   * @param name given to KTopLevelWidget
   * @param app holds the application object
   * @param kbmain holds the (non visual) Brahms main object
   * @param argc command line arguments
   * @param argv command line arguments
   * @see KbMain
   * @see IfMain
   * @see IfFactory
   * @see QtFactory
   */
  QtMain( const char * name, KApplication * app, KbMain * kbmain, int argc=0, char ** argv=0 );

  /**
   * to invoke the graphical presentation. This is called by in kbMain.C and delegated to
   * the exec method of the Brahms object (of type KApplication)
   * @see KbMain::KbMain
   * @see QtFactory::createMain
   */
  virtual void exec();

  /**
   * updates the presentation in the main window!
   */
  virtual void update();

  /*
   * returns the Brahms main object
   */
  KbMain * gMain();

  /**
   * creates preferences
   */
  void createPrefs();

  /**
   * create Bonus about Authors ;-)
   */
  void createAuthors();

  /**
   * returns the current time position (in midi ticks)
   */
  KbPosition gPos();

  /**
   * returns the track height
   */
  int gTrackHeight();

  /**
   * returns the track width
   */
  int gTrackWidth();

  /**
   * returns the string list with the device names
   */
  QStrList * gDevList();

  /**
   * adjusts the visualization of the tracks when the hight is changed
   */
  void adjustHeight();

  /**
   * returns the correlation between ticks and pixels drawn in the partCanvas
   */
  double gPixPerTick();

  /**
   * returns the bar offset that shall be presented in the part canvas
   */
  int gBarOff();


  /**
   * returns the canvas in which the tracks are displayed (on the left). For internal use only
   */
  QWidget * gLeft();

  /**
   * returns the canvas in which the parts are displayed (on the right). For internal use only
   */
  QtPartCanvas * gPartCanvas();

  /**
   * lets message appear in the status line
   */
  void msg(char * txt);

  bool gBeepFlag();

  bool gBeepMidi();

  int gClickInst();

  int gClickVol();
  
  int gPreBeats();

  bool gPlayWait();

  int gPartShow();

  void sBeepFlag(bool);

  void sBeepMidi(bool);
  
  void sClickInst(int);

  void sClickVol(int);
  
  void sPreBeats(int);

  void sPlayWait(bool);

  void sPartShow(int);

 public slots:

  void dropActionSlot1( KDNDDropZone * );
 
  void dropActionSlot2( KDNDDropZone * );
 
  void resizeEvent( QResizeEvent * );

  void fileMenu(int);

  void editMenu(int);

  void snapMenu(int);

  /**
   * runs the tasks from the toolbar
   */
  void tbMenu(int);

  /**
   * runs the tasks from the panel
   */
  void panelMenu(int);

  void updatePos();

  void updatePos(int);

  void updateTempo(int);

  void updateMeter1(int);
  
  void updateMeter2(int);

  void showPos();

  virtual void playInit();

  /**
   * communicates with the play process
   */
  // virtual void playListen();

  virtual void playExit();


};




// **********************************************
//
// HeadLine for the Trackpresentation on the left
// ==============================================
//


class QtHeadLine : public QLabel
{
  Q_OBJECT
public:
  QtHeadLine( int hot, QWidget *parent=0, const char *name=0);
private:
  int trackHeight;
  QLabel * mute;
  QLabel * lock;
  QLabel * type;
  QLabel * trname;
  QLabel * chnumber;
  QLabel * instname;
  QLabel * output;
  QLabel * vol;
  QLabel * tra;
  QLabel * del;
};


#endif
