#ifndef _QTPIANO_C_
#define _QTPIANO_C_


// ******************************************************************
//
// This is the implementation of the pianoroll editor
//
#include <qbitmap.h>
#include <qcursor.h>

#include "qtPiano.h"
#include "kbTrack.h"
#include "kbPart.h"
#include "kbNote.h"
#include "kbScoreTrack.h"

#define YTOP 118

int invPitch[] = {
  144,143,142,141,140, 138,137,136,135,134,133,132,
  130,129,128,127,126, 124,123,122,121,120,119,118,
  116,115,114,113,112, 110,109,108,107,106,105,104,
  102,101,100,99,98, 96,95,94,93,92,91,90,
  88,87,86,85,84, 82,81,80,79,78,77,76,
  74,73,72,71,70, 68,67,66,65,64,63,62,
  60,59,58,57,56, 54,53,52,51,50,49,48,
  46,45,44,43,42, 40,39,38,37,36,35,34,
  32,31,30,29,28, 26,25,24,23,22,21,20,
  18,17,16,15,14, 12,11,10,9,8,7,6,
  4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

int pitch[] = {
  124,123,122,121,120, 0 ,119,118,117,116,115,114,113, 0,
  112,111,110,109,108, 0, 107,106,105,104,103,102,101, 0,
  100,99,98,97,96, 0 ,95,94,93,92,91,90,89, 0,
  88,87,86,85,84, 0, 83,82,81,80,79,78,77, 0,
  76,75,74,73,72, 0, 71,70,69,68,67,66,65, 0,
  64,63,62,61,60, 0, 59,58,57,56,55,54,53, 0,
  52,51,50,49,48, 0, 47,46,45,44,43,42,41, 0,
  40,39,38,37,36, 0, 35,34,33,32,31,30,29, 0,
  28,27,26,25,24, 0, 23,22,21,20,19,18,17, 0,
  16,15,14,13,12, 0, 11,10,9,8,7,6,5, 0,
  4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

int pNoteTab[] = {
  'h', 'a', 'a', 'g', 'g', 'f', 'f', 'e', 'd', 'd', 'c', 'c'
};


// ******************************************************************
//
// Constructor
// ===========
//

QtPiano::QtPiano(KbPart * kbpart)
  : QtEditor("Piano Roll",kbpart,"Jan Wrthner"), yScale(4), ybottom(height()-12-64)
{
  QtEditor::init();                     // must call this to draw the window...
  setBackgroundMode( PaletteLight );    // set your background
  yoffset = YTOP;

  KIconLoader * loader = kapp->getIconLoader();
  
  cursorPM = loader->loadIcon( "cpr.xbm" );
  cursorBM = cursorPM;
  prcursor = new QCursor( cursorBM, cursorBM,0,20);

  buttonbar = new PButtonbar(this);
  addToolBar(buttonbar);
  buttonbar->show();

  setMaximumHeight(652);
}


// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void QtPiano::paintEvent( QPaintEvent * pe ) {
  
  QPixmap pix( width(), height() );    // for smooth display
  pix.fill( this, 10,10 );             // paint in pixmap !
  QPainter painter;
  painter.begin( &pix );

  xoffset = 120;
  yoffset = YTOP;
  int xxx = width();

  int yl = 0;
  int s;
  painter.drawRect(24,yoffset,xoffset-38,ybottom-yoffset);
  for (int i=1;i<=int((ybottom-yoffset)*0.5/yScale);i++) {
    yl = yoffset+i*2*yScale;
    painter.setPen(SolidLine);
    painter.drawLine(24,yl,xoffset-15,yl);
    s = i % 7;
    if ((s==1)||(s==2)||(s==4)||(s==5)||(s==6)) {
      painter.fillRect(24,yl-2,32,5,black);
      painter.setPen(DotLine);
    } else {
      if (s==3) painter.setPen(SolidLine); else painter.setPen(DashDotLine);
    }
    if (s!=0) painter.drawLine(xoffset,yl,xxx,yl);
  }
  painter.setPen(SolidLine);
  
  char help[20];
  int ytxt;
  for (int i=1;i<8;i++) {
    sprintf(help,"c%d",i);
    // c3: yoffset+78*yScale-7
    ytxt = yoffset+(8-i)*14*yScale+27;
    if (ytxt<ybottom) painter.drawText(8,ytxt,help);
  }
  //xLeft = KbPosition(1+xmOffset,1,0,master,met0,met1);
  //xRight = KbPosition(1+xmOffset+barnum,1,0,master,met0,met1);

  // pixPerTick is defined in QtEditor
  unsigned long xx;
  int beat;
  int bar;
  int tick;
  KbPosition pos = 0;
  KbPosition add = KbPosition(1,2,0,master,met0,met1); // one beat!
  char * txt = new char[12];
  bool draw = true;
  bool showNum;
  while (draw) {
    xx = pos.gPosTicks();
    xx = xx*pixPerTick + xoffset;
    pos.gBBT(bar,beat,tick,master,met0,met1);
    
    if (beat==1) {
      sprintf(txt,"%d \0",bar+posLeft.gBar(master,met0,met1)-1);
      showNum = false;
      if (pixPerTick>0.015625) showNum = true;
      else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
      else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
      else if ((bar&127)==1) showNum = true;
      if (showNum) painter.drawText(xx+1,yoffset-2,txt);
      if ((bar&7)==1) { painter.setPen(SolidLine); painter.drawLine(xx,yoffset,xx,ybottom); }
      else if (pixPerTick>0.0008) { painter.setPen(DashDotLine); painter.drawLine(xx,yoffset,xx,ybottom); }
    } else {
      if (pixPerTick>0.015625) { painter.setPen(DotLine); painter.drawLine(xx,yoffset,xx,ybottom); }
    }

    pos = pos + add;
    if (xx>xxx) draw=false;
  }
  painter.setPen(SolidLine);
  painter.drawLine(xoffset,yoffset,xxx,yoffset); // draw horizontal borders
  painter.drawLine(xoffset,ybottom,xxx,ybottom);

  KbNote* note = (KbNote*)part->gFirstNote();
  part = partList[selSystem];

  // the following loop goes through the part and draws the parts contents

  while (note!=0 && note->gPos()+part->gOffset() < posLeft) note = note->gNextNote();
  while (note!=0 && note->gPos()+part->gOffset() < posRight) {

    freq = note->gFreq();
    pos  = note->gPos()+part->gOffset();
    len  = note->gLen();
    vel = note->gVel();
    chan = note->gChan();
    next = note->gNextNote();
  
    // selX1 and selX2 are set to the selection. If there is no selection, selX1 is set to -1.
    // If selNote is not zero, it is a pointer to the note-cursor!
    // leftPos is the parts starting point (in ticks) and has to be taken into account. 
    if (selNote==note || (selX1!=-1 && selX1 <= pos && pos <= selX2)) fillColor = QColor(red); // painter.setPen(red); // selected Notes red !
    else {
      if (colorchan && (chan>-1)) fillColor = chancolor[chan];
      else fillColor = QColor(gray);
    }
    
    // --------------------------------------------------------
    // Do whatever you want with your note (freq,pos,len) here:
    //

    KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);
    xx = (pos-myLeftBar)*pixPerTick +  xoffset;

    yy = yoffset + yScale*invPitch[freq] + 1;

    xxLen = int(len*pixPerTick+0.4);

    if (yy+9<ybottom) {
      painter.fillRect(xx+1,yy+1,xxLen-2,yScale*2-3,fillColor);
      if (grabNote==note) painter.setPen(red);
      painter.drawRect(xx,yy,xxLen,yScale*2-1);
      if (grabNote==note) painter.setPen(black);
    }
    
    painter.drawRect(xx+1,ybottom+60,3,-vel/3);
    
    // --------------------------------------------------------

    if (selNote==note || (selX1!=-1 && selX1 <= pos && pos <= selX2)) fillColor = QColor(gray); // painter.setPen(black); // set pen back
    note = note->gNextNote();
  }

  // VOLUME RANGE:
  // -------------

  if (volGrabX1!=0)
    painter.drawLine(volGrabX1,volGrabY1,volGrabX2,volGrabY2);


  // SELECTIONS:
  // ----------


  if (grabX1!=0 && abs(grabX1-grabX2)>5 && volGrabX1==0) { // draw rect while selection is dragged!
    painter.setPen(gray);
    painter.drawRect(grabX1,yoffset+2,grabX2-grabX1,ybottom-yoffset-4);
  }


  // if (yPos!=0)  painter.fillRect(26,yPos,xoffset-40,yScale*2-2,blue);

  painter.end();
  bitBlt( this, 0, 0, &pix );
}



int QtPiano::Pitch(int y) {
  return pitch[int((y-yoffset-2.0)/yScale)];
}


// *****************************************************************************
//
// SLOTS
// =====
//


void QtPiano::mousePressEvent ( QMouseEvent * mouse ) {
  QtEditor::mousePressEvent(mouse);
  
  freq = Pitch(mouseDownY);
  pos = mouseDownPos.gPosTicks() - (mouseDownPos.gPosTicks()%snapValue) - part->gOffset();
  // getGrabNote(pos,freq);
  if (grabNote) repaint(FALSE);
  if (mouseDownX < xoffset) {
    if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),freq,velocValue);
  } else {
    if (mouseDownY > ybottom) {
      volGrabX1 = mouseX; volGrabY1 = mouseY;
      volGrabX2 = volGrabX1; volGrabY2 = volGrabY1;
      yGrab = mouseDownY;
    }
  }
}


void QtPiano::mouseMoveEvent  ( QMouseEvent * mouse ) {
  QtEditor::mouseMoveEvent(mouse);

  if (mouseY > yoffset && mouseY < ybottom-4) {
    if (mouseX > xoffset) {
      pos = mousePos.gPosTicks() - (mousePos.gPosTicks()%snapValue);
      int bar; int beat; int tick;
      pos.gBBT(bar,beat,tick,master,met0,met1);
      buttonbar->setPos(bar,beat,tick);
      if (grabNote) {
	if (shftFlag) {
	  int llen = (mousePos.gPosTicks()-grabPos.gPosTicks());
	  ((KbNote*)grabNote)->sLen(llen-llen%snapValue);
	} else {
	  KbPosition pos = mousePos.gPosTicks() - (mousePos.gPosTicks()%snapValue) - part->gOffset();
	  grabNote->sPos(pos);
	  setCursor(QCursor(6));
	}
    	repaint(FALSE);
      } else {
	setCursor(*prcursor);
      }
   
    } else {
      setCursor(QCursor(1));
    }
    
    freq = Pitch(mouseY);
    
    int nt = freq % 12;
    char ff = pNoteTab[11-nt];
    bool shftFlag = false;
    if ((nt==1)||(nt==3)||(nt==6)||(nt==8)||(nt==10)) shftFlag = true;
    buttonbar->setFreq(ff,(freq-nt)/12-2,shftFlag,false);

    yPos1 = yPos;
    yPos = yoffset + yScale*invPitch[freq] + 2;
    
    int s = freq%12;
    blackkey1 = blackkey;
    blackkey = 0;
    if ((s==1)||(s==3)||(s==6)||(s==8)||(s==10)) blackkey = true;
    extL1 = extL; extR1 = extR;
    extL = 1; extR = 1;
    if ((s==0)||(s==5)) extL = 3;
    if ((s==4)||(s==11)) { extR = -1; extL+=2; }
    QPainter painter;
    painter.begin(this);
    if (yPos1 && yPos1!=yPos) {
      if (blackkey1) {
	painter.fillRect(25,yPos1,31,5,black);
      } else {
	painter.fillRect(25,yPos1+extR1,31,2+extL1,white);
	painter.fillRect(56,yPos1-1,xoffset-71,2*yScale-1,white);
      }
    }
    if (yPos) {
      if (blackkey) {
	painter.fillRect(25,yPos,31,5,red);
      } else {
	painter.fillRect(25,yPos+extR,31,2+extL,red);
	painter.fillRect(56,yPos-1,xoffset-71,2*yScale-1,red);
      }
    }
    // painter.fillRect(26,yPos,xoffset-40,yScale*2-2,yellow);
    painter.end();
    // setCursor(QCursor(1));
    if (grabX1!=0) repaint(false);
  }
  if (mouseY>ybottom) { setCursor(QCursor(2)); if (volGrabX1!=0) { volGrabX2 = mouseX; volGrabY2 = mouseY; repaint(false); } }

}


void QtPiano::mouseReleaseEvent ( QMouseEvent * mouse ) {
  QtEditor::mouseReleaseEvent(mouse);

  freq = Pitch(mouseRelY);
  
  if (mouseY>ybottom) createNote = false;

  if (mouseRelX > xoffset) {
      pos = mouseRelPos.gPosTicks() - (mouseRelPos.gPosTicks()%snapValue) - part->gOffset();
      if (grabNote) {

      } else {
	if (createNote) {
	  int llen = ticksOfLen(lenValue);
	  if (mouse->button()==LeftButton) {
	    if (freq!=0) {
	      part->addNote(new KbNote(freq,velocValue,llen,pos,0));
	      grabX1=0; // if a note is created, no selection-frame should be displayed
	      if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),freq,velocValue);
	    }
	    
	  }
	} else { // SELECTION

	  /*selX1 = KbPosition(x1*1.0/pixPerTick) + xLeft;
	    selX2 = KbPosition(x*1.0/pixPerTick) + xLeft;
	  selX1.snap(snapValue);
	  selX2.snap(snapValue);
	  
	  if (selX1>=selX2) {
	    enableSelItems(FALSE);
	    selX1 = -1;
	  } else {
	    enableSelItems(TRUE);
	    selFrame->setTop(selX1.gTicks(master,met0,met1),selX1.gBeat(master,met0,met1),selX1.gBar(master,met0,met1));
	    selFrame->setBottom(selX2.gTicks(master,met0,met1),selX2.gBeat(master,met0,met1),selX2.gBar(master,met0,met1));
	  }
	  grabX1 = 0;
	  repaint(FALSE);
	 */ 
	}

	if (mouseRelY > ybottom) { // VOLUME
	  int yAux = 60;
	  KbNote * n = 0;
	  KbNote * m = 0;
	  KbPosition p = KbPosition((volGrabX1-xoffset)*1.0/pixPerTick) + posLeft;
	  for (n = part->gFirstNote(); n!=0 && (n->gPos()+part->gOffset()<p); n = (KbNote*)n->gNextNote()) {}
	  if (n!=0) {
	    p = KbPosition((volGrabX2-xoffset)*1.0/pixPerTick) + posLeft;
	    for (m = n; m!=0 && (m->gPos()+part->gOffset()<p); m = (KbNote*)m->gNextNote()) {}
	    if (m!=0) { // range is now: [n,m]
	      //cout << *n << endl << *m << endl;
	      int ry1 = ybottom+yAux-yGrab;
	      int ry2 = ybottom+yAux-mouse->y();
	      int deltax = (m->gPos().gPosTicks()-n->gPos().gPosTicks());
	      int deltay = (ry2-ry1)*3.0;
	      // cout << "yGrab: " << yGrab << " : " << ry1 << ", " << ry2 << endl;
	      double slope = deltay*1.0/deltax;
	      //cout << "slope: " << slope << endl;
	      for (KbNote * note = n; note!=m; note = note->gNextNote())
		note->sVel(3*ry1+int(slope*(note->gPos().gPosTicks()-n->gPos().gPosTicks())));
	    }
	  }
	  volGrabX1 = 0;
	  
	}
	
      }
      
  }

  /*
  int x = mouse->x() - xoffset + 1;
  
  if (x>0) {
    pos = int(x*1.0/pixPerTick) + xLeft.gPosTicks(); // + leftPos;
    pos = pos.gPosTicks() - (pos.gPosTicks()%snapValue);
    
    if (createNote==TRUE) {
      int llen = ticksOfLen(lenValue); // set current length value
      
      // **********************************
      // Left Button: Create Note:
      // -------------------------
      //

      if (mouse->button()==LeftButton && grabNote==0) {

	// freq = int((yoffset+720-mouse->y()+4)/8); // do some conversion...
	freq = pitch[int((mouse->y()-yoffset-2.0)/yScale)];
	if (freq!=0) {
	  part->addNote(new KbNote(freq,velocValue,llen,pos,0));
	  grabX1=0; // if a note is created, no selection-frame should be displayed
	  if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),freq,velocValue);
	}
      }

      // **********************************
      // Middle Button: Select Note:
      // ---------------------------
      //

      if (mouse->button()==MidButton) {
	
	KbNote * n;
	for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]+leftPos<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
	selNote = n;
	if (selNote!=0) showNoteInfo();
	else showNoteInfoOff();
	repaint( FALSE );
	//if (n!=0) soundHit(part->gTrack()->gOutput(),part->gTrack()->gChannel(),n->gFreq(),velocValue); // plays the note
      }

      // **********************************
      // Right Button: Delete Note:
      // --------------------------
      //

      if (mouse->button()==RightButton) {
	KbNote * n;
	for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]+leftPos<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
	if (n!=0) {
	  part->deleteNote(n);
	  selNote = 0;
	  showNoteInfoOff();
	  repaint( FALSE );
	}
      }
    }  else { // SELECTION
      
      selX1 = KbPosition(x1*1.0/pixPerTick) + xLeft;
      selX2 = KbPosition(x*1.0/pixPerTick) + xLeft;
      selX1.snap(snapValue);
      selX2.snap(snapValue);

      if (selX1>=selX2) {
	enableSelItems(FALSE);
	selX1 = -1;
      } else {
	enableSelItems(TRUE);
	selFrame->setTop(selX1.gTicks(master,met0,met1),selX1.gBeat(master,met0,met1),selX1.gBar(master,met0,met1));
	selFrame->setBottom(selX2.gTicks(master,met0,met1),selX2.gBeat(master,met0,met1),selX2.gBar(master,met0,met1));
      }
      grabX1 = 0;
      repaint(FALSE);
      
    }

    if (mouse->y() > ybottom) { // VOLUME
      int yAux = 60;
      KbNote * n = 0;
      KbNote * m = 0;
      KbPosition p = KbPosition((volGrabX1-xoffset)*1.0/pixPerTick) + xLeft;
      for (n = part->gFirstNote(); n!=0 && (n->gPos()+leftPos<p); n = (KbNote*)n->gNextNote()) {}
      if (n!=0) {
	p = KbPosition((volGrabX2-xoffset)*1.0/pixPerTick) + xLeft;
	for (m = n; m!=0 && (m->gPos()+leftPos<p); m = (KbNote*)m->gNextNote()) {}
	if (m!=0) { // range is now: [n,m]
	  //cout << *n << endl << *m << endl;
	  int ry1 = ybottom+yAux-yGrab;
	  int ry2 = ybottom+yAux-mouse->y();
	  int deltax = (m->gPos().gPosTicks()-n->gPos().gPosTicks());
	  int deltay = (ry2-ry1)*3.0;
	  cout << "yGrab: " << yGrab << " : " << ry1 << ", " << ry2 << endl;
	  double slope = deltay*1.0/deltax;
	  //cout << "slope: " << slope << endl;
	  for (KbNote * note = n; note!=m->gNextNote(); note = note->gNextNote())
	    note->sVel(3*ry1+int(slope*(note->gPos().gPosTicks()-n->gPos().gPosTicks())));
	}
      }
      volGrabX1 = 0;

    }

  } else {
    // mouse released in left region
  }
  grabNote = 0;
  */
  volGrabX1 = 0;
  repaint( FALSE );

}


// For special key events

void QtPiano::keyPressEvent ( QKeyEvent * key ) {
  part = partList[selSystem];
  switch( key->key() ) {
  case Key_Left:
    if (selNote==0) {
      if (part->gFirstAtom()) part->sCur(part->gLastAtom()); selNote = part->gCurAtom(); showNoteInfo();
    } else {
      part->sCur(selNote);
      if (part->leftNote()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
    if (selNote!=0) {
      if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),((KbNote*)selNote)->gFreq(),((KbNote*)selNote)->gVel());
    }
    break;
  case Key_Right:
    if (selNote==0) {
      if (part->gFirstAtom()) part->sCur(part->gFirstAtom()); selNote = part->gCurAtom(); showNoteInfo();
    }
    else {
      part->sCur(selNote);
      if (part->rightNote()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
    if (selNote!=0) {
      if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),((KbNote*)selNote)->gFreq(),((KbNote*)selNote)->gVel());
    }
  break;
  default:
    QtEditor::keyPressEvent(key);
    break;
  }
  repaint(FALSE);
}


void QtPiano::keyReleaseEvent ( QKeyEvent * key ) {
  QtEditor::keyReleaseEvent(key);

}


void QtPiano::resizeEvent( QResizeEvent * re ) {
  QtEditor::resizeEvent(re);
  // setFixedHeight(parts*(100+yAux)+YTOP);
  ybottom = height()-12-64;
}



#endif
