#ifndef _QTPIANO_H_
#define _QTPIANO_H_

#include "qtEditor.h"
#include "qtPianoButtons.h"
#include "kbPosition.h"

class KbNote;
class KbPart;
class QBitmap;

/**
 * Qt implementation of the piano roll editor
 * @author ?
 * @version ?
 */
class QtPiano : public QtEditor
{
  Q_OBJECT

 private:

  // used for the range (in ticks) that is to be displayed
  //KbPosition xLeft;
  //KbPosition xRight;

  // ticks per bar
  int ticksPerBar;

  // y scale
  int yScale;
  int x1;
  int ybottom;

  // pos on piano
  int yPos;
  int yPos1;
  bool blackkey;
  bool blackkey1;
  int extL; int extR;
  int extL1; int extR1;

  // used for a notes information in paintEvent
  KbNote * next;
  int freq;
  int len;
  int vel;
  int chan;

  // coordinates, used at several places...
  int xx;
  int yy;
  int xxLen;

  char barText[5];

  PButtonbar * buttonbar;
  QPixmap cursorPM;
  QBitmap cursorBM;
  QCursor * prcursor;
    
  QColor fillColor;
  
 public:

  /**
   * constructor, takes the part to be displayed as a parameter
   */
  QtPiano(KbPart * kbpart);

  virtual int Pitch(int);

 public slots:
  
  /// do all the painting here
  void paintEvent ( QPaintEvent * );

  /// mouse is pressed here
  void mousePressEvent ( QMouseEvent * );

  /// mouse is moved
  void mouseMoveEvent ( QMouseEvent * );

  /// mouse is released
  void mouseReleaseEvent ( QMouseEvent * );

  /// a key is pressed
  void keyPressEvent ( QKeyEvent * );

  /// a key is released
  void keyReleaseEvent ( QKeyEvent * );

  virtual void resizeEvent( QResizeEvent * );

};

#endif
