#ifndef _QTPREFS_H_
#define _QTPREFS_H_

#include "qtMain.h"
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include "ifPrefs.h"

class QtMain;

/**
 * The qt implementation of the preferences GUI.
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtPrefs : public QLabel, public IfPrefs
{
  Q_OBJECT
 private:
  QtMain * qtmain;

 public:
  QtPrefs( QWidget * parent , const char * name );
  ~QtPrefs();
  QTabDialog * dialog;
  QGroupBox * group1;
  QGroupBox * group2;
  QWidget * pref1;
  QWidget * pref2;
  QWidget * pref3;
  QLabel * l11;
  QLabel * l12;
  QLabel * l13;
  QLabel * l14;
  QLabel * l15;
  QLabel * l16;
  QLabel * l21;
  QCheckBox * c11;
  QCheckBox * c12;
  QCheckBox * c13;
  QCheckBox * c21;
  QSpinBox * s11;
  QSpinBox * s12;
  QSpinBox * s13;
  QButtonGroup * g31;
  QRadioButton * r31;
  QRadioButton * r32;

public slots:
  void updateC1(bool);
  void updateC2(bool);
  void updateS1(int);
  void updateS2(int);
  void updateS3(int);

  void updateC21(bool);
  
  void updateG31(int);};

#endif
