#ifndef _QTSAMPLE_C_
#define _QTSAMPLE_C_


// ******************************************************************
//
// This is the implementation of the sample editor
//

#include "qtSampleEditor.h"
#include "kbTrack.h"
#include "kbPart.h"
#include "kbNote.h"

#define YTOP 112

// ******************************************************************
//
// Constructor
// ===========
//

// call the QtEditor constructor with the parameters: Windowname,
//                                                    part to be displayed
//                                                    Your name.
// your name will then appear in the editors about box
//

QtSampleEditor::QtSampleEditor(KbPart * kbpart)
  : QtEditor("Sample Editor",kbpart,"Joe Smow")
{
  QtEditor::init();                     // must call this to draw the window...
  setBackgroundMode( PaletteLight );    // set your background

}


// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void QtSampleEditor::paintEvent( QPaintEvent * pe ) {
  
  QPixmap pix( width(), height() );    // for smooth display
  pix.fill( this, 10,10 );             // paint in pixmap !
  QPainter painter;
  painter.begin( &pix );

  //time1 = part->gTime1();              // get part information
  //time2 = part->gTime2();              // (meter!)
      
  //xLeft  = xmOffset*1536*time1/time2;  // set range to be displayed
  //xRight = xLeft+1536*time1/time2*barnum;
      
  //ticksPerBar = int(1536.0*time1/time2);

  yoffset = YTOP;
  xoffset  = 120;
  // barlen   = (width()-xoffset)/barnum; // the length of a bar in pixels

  //sprintf(barText, "%d", leftBar+xmOffset+1);
  //painter.setFont(QFont("Helvetica",12,QFont::Normal,TRUE));
  //painter.drawText(xoffset,yoffset-14,barText); // draw bar number

  //  for (int i=0; i<=barnum; i++) { // draw vertical bar lines
  //  painter.drawLine(xoffset+i*barlen,yoffset,xoffset+i*barlen,height()-12);
  // }
  //painter.drawLine(xoffset,yoffset,xoffset+barnum*barlen,yoffset); // draw horizontal borders
  //painter.drawLine(xoffset,height()-12,xoffset+barnum*barlen,height()-12);

  KbNote* note = (KbNote*)part->gFirstAtom();

  // the following loop goes through the part and draws the parts contents

  while (note!=0 && note->gPos()<xLeft) note = (KbNote*)note->gNext();
  while (note!=0 && note->gPos()<xRight) {
    freq = note->gFreq();
    pos  = note->gPos();
    len  = note->gLen();
    // enh  = note->gEnh(); // You usually do not need enharmonic shift except for score editing!
    next = (KbNote*) note->gNext();


    // selX1 and selX2 are set to the selection. If there is no selection, selX1 is set to -1.
    // If selNote is not zero, it is a pointer to the note-cursor!
    // leftPos is the parts starting point (in ticks) and has to be taken into account. 
    // if (selNote==note || (selX1!=-1 && selX1 <= pos+leftPos && pos+leftPos <= selX2)) painter.setPen(red); // selected Notes red !
    
    // --------------------------------------------------------
    // Do whatever you want with your note (freq,pos,len) here:
    //

    /* xx = xoffset + int(pos*barlen*(1.0*time2/(1536*time1)-xmOffset)); // suggestion for horizontal position
    yy = yoffset + 400-8*freq;                                        // suggestion for vertical position
    xxLen = int(barlen*(1.0*time2/(1536*time1)*len));

    painter.drawRect(xx,yy,xxLen,7);
    */


    
    // --------------------------------------------------------
    /*
    if (selNote==note || (selX1!=-1 && selX1 <= pos+leftPos && pos+leftPos <= selX2)) painter.setPen(black); // set pen back
    note = (KbNote*)note->gNext();
    */
  }

  // SELECTIONS:
  // -----------
  /*
  if (grabX1!=0 && abs(grabX1-grabX2)>5) { // draw rect while selection is dragged!
    painter.drawRect(grabX1,yoffset-12,grabX2-grabX1,6);
  }
  */

  painter.end();
  bitBlt( this, 0, 0, &pix );
}




// *****************************************************************************
//
// SLOTS
// =====
//


void QtSampleEditor::mousePressEvent ( QMouseEvent * mouse ) {
  QtEditor::mousePressEvent(mouse);
  
  int mp = mouse->x();
  // int tp = timeOfMouse(mp);

  //if (tp!=-1) {
    
    // mouse pressed in left region

  //  } else {

    // mouse pressed in right region
    
  //  }
  
}


void QtSampleEditor::mouseMoveEvent  ( QMouseEvent * mouse ) {
  QtEditor::mouseMoveEvent(mouse);

  int x = mouse->x();
  if (x>xoffset) {
    // you could use this to show the mouse-position
    // cout << "mouse move " << main->gBar() << ", " << main->gBeat() << ", " << main->gTick() << endl;
  }

  setCursor(QCursor(2));
}


void QtSampleEditor::mouseReleaseEvent ( QMouseEvent * mouse ) {
  QtEditor::mouseReleaseEvent(mouse);
  /*
  int x = mouse->x();
  
  if (x>xoffset) {
    pos = timeOfMouse(x);
    // cout << "mouse released at " << pos-leftPos << endl;
    
    if (createNote==TRUE) {
      int llen = ticksOfLen(lenValue); // set current length value
      
      // **********************************
      // Left Button: Create Note:
      // -------------------------
      //

      if (mouse->button()==LeftButton) {

	freq = int((yoffset+400-mouse->y()+4)/8); // do some conversion...
	part->addNote(new KbNote(freq,velocValue,llen,pos-leftPos,0));
	grabX1=0; // if a note is created, no selection-frame should be displayed
	//soundHit(part->gTrack()->gOutput(),part->gTrack()->gChannel(),freq,velocValue); // plays the note
      }

      // **********************************
      // Middle Button: Select Note:
      // ---------------------------
      //

      if (mouse->button()==MidButton) {
	
	KbNote * n;
	for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
	selNote = n;
	if (selNote!=0) showNoteInfo();
	else showNoteInfoOff();
	repaint( FALSE );
      }

      // **********************************
      // Right Button: Delete Note:
      // --------------------------
      //

      if (mouse->button()==RightButton) {
	KbNote * n;
	for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
	if (n!=0) {
	  part->deleteNote(n);
	  selNote = 0;
	  showNoteInfoOff();
	  repaint( FALSE );
	}
      }
    }
  } else {
    // mouse released in left region
    cout << "mouse released in left region" << endl;
  }
  repaint( FALSE );
  */
}


// For special key events

void QtSampleEditor::keyPressEvent ( QKeyEvent * key ) {
  QtEditor::keyPressEvent(key);

}


void QtSampleEditor::keyReleaseEvent ( QKeyEvent * key ) {
  QtEditor::keyReleaseEvent(key);

}


// dont forget to adjust this include:



#endif
