#ifndef _QTSCORETRACK_C_
#define _QTSCORETRACK_C_

#include "kbTrack.h"
#include "kbScoreTrack.h"
#include "qtScoreTrack.h"
#include <iostream.h>

extern const char * gmNames[];



QtScoreTrack::QtScoreTrack(KbTrack * kbtrack)
  : QtTrack(kbtrack)
{
  
  KIconLoader * loader = kapp->getIconLoader();
  
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute.xpm" ));

  int hh = height();

  mute = new TogBut( 0, track, pmMute, 0, this, "mute" );
  mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  mute->setGeometry(0,0,24,hh+1);

  instbox = new QComboBox(FALSE,this,"instrument");
  instbox->insertStrList( gmNames );
  instbox->setCurrentItem(((KbScoreTrack*)track)->gProgram());
  instbox->setGeometry(168,0,160,hh+1);
  connect(instbox,SIGNAL(highlighted(int)),SLOT(updateInst(int)));

  output = new QComboBox(FALSE,this,"output");
  output->insertStrList( ((QtMain*)kbtrack->gMain()->gInterface())->gDevList() );
  output->setCurrentItem(((KbScoreTrack*)track)->gOutput());
  output->setGeometry(328,0,96,hh+1);
  connect(output,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  chanbox = new QSpinBox(0,15,1,this);
  chanbox->setFrameStyle( QFrame::Panel | QFrame::Raised );
  chanbox->setGeometry(424,0,44,hh+1);
  chanbox->setValue(((KbScoreTrack*)track)->gChannel());
  chanbox->setBackgroundMode( PaletteMid );
  connect(chanbox,SIGNAL(valueChanged(int)),SLOT(updateChan(int)));

  vol = new QSpinBox(-99,99,1,this);
  vol->setFrameStyle( QFrame::Panel | QFrame::Raised );
  vol->setGeometry(468,0,54,hh+1);
  vol->setValue(((KbScoreTrack*)track)->gVolume());
  vol->setBackgroundMode( PaletteMid );
  connect(vol,SIGNAL(valueChanged(int)),SLOT(updateVol(int)));

  tra = new QSpinBox(-99,99,1,this);
  tra->setFrameStyle( QFrame::Panel | QFrame::Raised );
  tra->setGeometry(522,0,54,hh+1);
  tra->setValue(((KbScoreTrack*)track)->gTranspose());
  tra->setBackgroundMode( PaletteMid );
  connect(tra,SIGNAL(valueChanged(int)),SLOT(updateTra(int)));

  del = new QSpinBox(-99,99,1,this);
  del->setFrameStyle( QFrame::Panel | QFrame::Raised );
  del->setGeometry(576,0,54,hh+1);
  del->setValue(((KbScoreTrack*)track)->gDelay());
  del->setBackgroundMode( PaletteMid );
  connect(del,SIGNAL(valueChanged(int)),SLOT(updateDel(int)));

  type->chooseScore();
}

/*QtScoreTrack::~QtScoreTrack() {

  }*/


void QtScoreTrack::erase() {
  delete this;
}


void QtScoreTrack::update() {
  QtTrack::update();
  mute->update(); track->gMain()->muteTrack(track->trackNum());
  instbox->setCurrentItem(((KbScoreTrack*)track)->gProgram());
  output->setCurrentItem(((KbScoreTrack*)track)->gOutput());
  chanbox->setValue(((KbScoreTrack*)track)->gChannel());
  vol->setValue(((KbScoreTrack*)track)->gVolume());
  tra->setValue(((KbScoreTrack*)track)->gTranspose());
  del->setValue(((KbScoreTrack*)track)->gDelay());
  /*  
  if (track->gToggle(1)==FALSE && track->gToggle(2)==FALSE) { // type & lock are false!
    chanbox->setEnabled(TRUE);
    instbox->setEnabled(TRUE);
    output->setEnabled(TRUE);
  } else {
    chanbox->setEnabled(FALSE);
    instbox->setEnabled(FALSE);
    output->setEnabled(FALSE);
  }
  if (track->gToggle(2)==FALSE) { // lock is false
    vol->setEnabled(TRUE);
    del->setEnabled(TRUE);
  } else {
    vol->setEnabled(FALSE);
    del->setEnabled(FALSE);
  }
  */
  show();
}

void QtScoreTrack::adjustHeight() {
  QtTrack::adjustHeight();
  int n = track->trackNum()+1;
  int hh = height();
  trname->setGeometry(72,0,96,hh+1);
  instbox->setGeometry(168,0,160,hh+1);
  output->setGeometry(328,0,96,hh+1);
  chanbox->setGeometry(424,0,44,hh+1);
  vol->setGeometry(468,0,54,hh+1);
  tra->setGeometry(522,0,54,hh+1);
  del->setGeometry(576,0,54,hh+1);
}


int QtScoreTrack::gProgram() {
  // return instbox->getCurrentItem();
}

void QtScoreTrack::sProgram(int n) {
  ((KbScoreTrack*)track)->sProgram(n);
  instbox->setCurrentItem(n);
}

void QtScoreTrack::updateChan(int n) {
  ((KbScoreTrack*)track)->sChannel(n);
}

void QtScoreTrack::updateInst(int n) {
  ((KbScoreTrack*)track)->sProgram(n);
  track->gMain()->updateInst(track->trackNum(),n);
}

void QtScoreTrack::updateOut(int n) {
  ((KbScoreTrack*)track)->sOutput(n);
}

void QtScoreTrack::updateVol(int n) {
  ((KbScoreTrack*)track)->sVolume(n);
  track->gMain()->updateVol(track->trackNum());
}

void QtScoreTrack::updateTra(int n) {
  ((KbScoreTrack*)track)->sTranspose(n);
  track->gMain()->updateTra(track->trackNum());
}

void QtScoreTrack::updateDel(int n) {
  ((KbScoreTrack*)track)->sDelay(n);
}









#endif
