#ifndef _QTSCORETRACK_H_
#define _QTSCORETRACK_H_

#include "qtTrack.h"


/**
 * This is the qt implementation of a scoreTrack
 * @author Jan Wuerthner
 * @versoin 0.97
 */
class QtScoreTrack : public QtTrack
{
  Q_OBJECT

 private:
  TogBut * mute;
  QSpinBox * chanbox;
  QComboBox * instbox;
  QComboBox * output;
  QSpinBox * vol;
  QSpinBox * tra;
  QSpinBox * del;
 public:

  /// Constructor
  QtScoreTrack(KbTrack*);

  /// Destructor
  //~QtScoreTrack();
  virtual void erase();

  /// updates the presentation on the screen
  virtual void update();

  virtual void adjustHeight();

  /// returns current instrument
  int gProgram();

  /// sets an instrument
  void sProgram(int n);

 public slots:
  void updateChan(int);
  void updateInst(int);
  void updateOut(int);
  void updateVol(int);
  void updateTra(int);
  void updateDel(int);
};






#endif
