#ifndef _QTTEEDIT_C_
#define _QTTEEDIT_C_

#include "qtTEEdit.h"
#include "kbPart.h"
#include "kbMain.h"
#include "kbTrack.h"
#include <string.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include "math.h"
#include "kbMasterEvent.h"
#include "kbAtom.h"
#include "kbPosition.h"

QtTEEdit::QtTEEdit(KbPart * p) : part(p), main(p->gTrack()->gMain()), newPos(0), newTempo(120), time1(4), time2(2), index(-1) {
  author = strdup("Jan Wrthner");

  setFixedWidth(190);
  setFixedHeight(300);

  QLabel * title = new QLabel("Mastertrack",this);
  title->setGeometry(2,2,186,22);

  view = new QListBox(this);
  view->setGeometry(2,24,186,154);
  showView();
  view->show();
  connect(view,SIGNAL(selected(int)),SLOT(enableDelete(int)));

  QLabel * lPos = new QLabel("position",this);
  lPos->setGeometry(2,184,64,18);

  QLabel * lTempo = new QLabel("tempo",this);
  lTempo->setGeometry(68,184,64,18);

  QLabel * lMeter = new QLabel("meter",this);
  lMeter->setGeometry(124,184,64,18);

  posline = new QLineEdit(this);
  posline->setGeometry(2,204,64,18);
  posline->show();
  
  templine = new QLineEdit(this);
  templine->setGeometry(68,204,64,18);
  templine->show();

  metline0 = new QLineEdit(this);
  metline0->setGeometry(124,204,64,18);
  metline0->show();

  /*  metline1 = new QLineEdit(this);
  metline1->setGeometry(124,236,30,18);
  metline1->show();
  */
  QPushButton * addTempoBtn = new QPushButton("set tempo",this);
  addTempoBtn->setGeometry(2,224,92,20);
  addTempoBtn->show();
  connect(addTempoBtn,SIGNAL(released()),SLOT(addTempo()));

  QPushButton * addMeterBtn = new QPushButton("set meter",this);
  addMeterBtn->setGeometry(96,224,92,20);
  addMeterBtn->show();
  connect(addMeterBtn,SIGNAL(released()),SLOT(addMeter()));

  delBtn = new QPushButton("remove",this);
  delBtn->setGeometry(2,250,48,48);
  delBtn->show();
  connect(delBtn,SIGNAL(released()),SLOT(remove()));
  delBtn->setEnabled(false);

  QPushButton * exit = new QPushButton(" OK ",this);
  exit->setGeometry(140,250,48,48);
  exit->show();
  connect(exit,SIGNAL(released()),SLOT(exit()));

}

void QtTEEdit::enableDelete(int i) {
  index = i;
  delBtn->setEnabled(true);
  int k = 0;
  for (KbAtom * a = part->gFirstAtom();(a!=0)&&(k<index);a=a->gNext()) {
    if (a->isMasterEvent()) k++;
  }
  if (a!=0) {
    KbMasterEvent * te = (KbMasterEvent*) a;
    char * x = new char[40];
    KbPosition pos = te->gPos();
    sprintf(x,"%d. %d. %d\0",pos.gBar(part),pos.gBeat(part),pos.gTicks(part));
    posline->setText(x);
    if (te->gTempo()>0) { sprintf(x,"%d\0",te->gTempo()); templine->setText(x); metline0->setText(""); }
    else { sprintf(x,"%d / %d\0",te->gMeter0(),te->gMeter1()); metline0->setText(x); templine->setText(""); }
    delete[] x;
  }
}

QtTEEdit::~QtTEEdit() {
  delete view;
  delete posline;
  delete templine;
  delete metline0;

}

void QtTEEdit::pos() {
  posline->clearFocus();
  const char * line = posline->text();
  int x1 = atoi(line);
  for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
  int x2 = atoi(line);
  for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
  int x3 = atoi(line);
  // x1 . x2 . x3

  newPos = KbPosition(x1,x2,x3,part);
      
  // int ticks = int(1536.0*time1/pow(2,time2));
  // newPos = ticks*(x1-1) + ticks*(x2-1)/time1 + x3;
  //posline->setText("");
}

void QtTEEdit::temp() {
  templine->clearFocus();
  newTempo = atoi(templine->text());
  templine->setText("");
}

void QtTEEdit::meter() {
  metline0->clearFocus();
  char * mtxt = metline0->text();
  newMeter0 = atoi(mtxt);
  int i = 0;
  for (;(mtxt[0]!='/')&&(i<10);i++) mtxt++;
  mtxt++;
  newMeter1 = atoi(mtxt);
  if (newMeter1<1) newMeter1 = 4;
  metline0->setText("");
}

void QtTEEdit::addTempo() {
  pos();
  temp();
  // cout << "pos: " << newPos.gPosTicks() << endl;
  if ((newPos>=0)&&(newTempo>0)) {
    if (index!=-1) {
      int i = 0; for (KbAtom * a = part->gFirstAtom();(a!=0)&&(i<index);a=a->gNext()) if (a->isMasterEvent()) i++;
      if (a!=0) part->deleteNote(a);
    }
    KbMasterEvent * newTE = new KbMasterEvent(newPos,newTempo);
    part->addAtom(newTE);
    showView();
  }
}

void QtTEEdit::addMeter() {
  pos();
  meter();
  if ((newMeter0>0) && (newMeter1>0) && (newPos>=0)) {
    if (index!=-1) {
      int i = 0; for (KbAtom * a = part->gFirstAtom();(a!=0)&&(i<index);a=a->gNext()) if (a->isMasterEvent()) i++;
      if (a!=0) part->deleteNote(a);
    }
    KbMasterEvent * newME = new KbMasterEvent(newPos,newMeter0,newMeter1);
    part->addAtom(newME);
    showView();
  }
}

void QtTEEdit::remove() {
  int i = 0;
  for (KbAtom * a = part->gFirstAtom();(a!=0)&&(i<index);a=a->gNext()) {
    if (a->isMasterEvent()) i++;
  }
  if (a!=0) {
    if ((i>index)||(a->isMasterEvent()!=true)) printf("PANIC QTTEEDIT");
    else part->deleteNote(a);
  }
  showView();
}

void QtTEEdit::exit() {
  delete this;
}

KbPart * QtTEEdit::gPart() { return part; }

void QtTEEdit::insertTE(KbMasterEvent * te) {
  char * x = new char[40];
  KbPosition pos = te->gPos();
  if (te->gTempo()==0) { // meter
    sprintf(x,"%d. %d. %d :      %d / %d\0",pos.gBar(part),pos.gBeat(part),pos.gTicks(part),te->gMeter0(),te->gMeter1());
  } else { // tempo
    sprintf(x,"%d. %d. %d : %d\0",pos.gBar(part),pos.gBeat(part),pos.gTicks(part),te->gTempo());
  }
  view->insertItem(x);
  delete[] x;
}

void QtTEEdit::showView() {
  
  view->clear();
  for (KbAtom * a = part->gFirstAtom();a!=0;a=a->gNext()) {
    if (a->isMasterEvent()) {
      insertTE( (KbMasterEvent*) a); 
    }
  }
  view->clearSelection();
  index = -1;
}

#endif
