#ifndef _QTTEEDIT_H_
#define _QTTEEDIT_H_

//#include <qlistview.h> 
#include <ktopwidget.h>
#include "ifEditor.h"
#include "kbPosition.h"

class KbPart;
class KbMain;
class QLineEdit;
class QListBox;
class QPushButton;
class KbMasterEvent;

class QtTEEdit : public KTopLevelWidget, public IfEditor
{
  Q_OBJECT

 private:
  
  int index;
  char * author;
  QListBox * view;
  QLineEdit * posline;
  QLineEdit * templine;
  QLineEdit * metline0;
  QLineEdit * metline1;
  QPushButton * delBtn;

 protected:

  KbPart * part;
  KbMain * main;
  int time1;
  int time2;
  KbPosition newPos;
  int newTempo;
  int newMeter0;
  int newMeter1;


 public:

  QtTEEdit(KbPart * kbpart);

  ~QtTEEdit();

  /**
   * returns the part under consideration
   */
  KbPart * gPart();

  void insertTE(KbMasterEvent*);
  void showView();
  void pos();
  void temp();
  void meter();

 public slots:
  
  void addTempo();
  void addMeter();
  void remove();
  void enableDelete(int);
  void exit();
};


#endif
