#ifndef _QTTRANS_C_
#define _QTTRANS_C_

#include <qspinbox.h>

#include "qtTrans.h"
#include "kbPart.h"
#include "kbTrack.h"
#include "kbAtom.h"
#include "kbNote.h"

QtTranspose::QtTranspose(KbPosition a, KbPosition b, KbPart * p, QtEditor * e)
  : QLabel(0,"Transpose",WStyle_Customize | WStyle_DialogBorder), part(p), editor(e), left(0), right(0)
{
  setCaption("Transpose");
  
  //setBackgroundMode( PaletteLight );
  setFixedSize(195,100);
  KIconLoader *loader = kapp->getIconLoader();

  if (b.gPosTicks()==0) { // transpose system!
    a = part->gFirstNote()->gPos();
    b = part->gLastNote()->gPos();
  }
  for (KbAtom * atom = part->gFirstAtom(); atom != 0;) {
    if ((left==0) && (atom->gPos()>=a)) left = atom;
    if ((right==0) && (atom->gPos()>b)) right = atom;
    if (left && right) atom = 0;
    else atom = atom->gNext();
  }

  char * rangetxt = new char[60];
  int bar1; int beat1; int tick1; int bar2; int beat2; int tick2;
  KbPart * master =part->gTrack()->gMain()->Master();
  int met0 = part->gTrack()->gMain()->gMeter(0);
  int met1 = part->gTrack()->gMain()->gMeter(1);
  a.gBBT(bar1,beat1,tick1,master,met0,met1);
  b.gBBT(bar2,beat2,tick2,master,met0,met1);
  sprintf(rangetxt,"Range: %d. %d. %d to %d. %d. %d \0",bar1,beat1,tick1,bar2,beat2,tick2);
  QLabel * range = new QLabel(rangetxt,this);
  range->setGeometry(0,14,width(),14);
  range->show();
  delete rangetxt;

  QLabel * lab = new QLabel("Transpose: ",this);
  lab->setGeometry(0,40,120,20);
  lab->show();

  value = new QSpinBox(-24,24,1,this);
  value->setFrameStyle( QFrame::Panel | QFrame::Raised );
  value->setGeometry(122,40,70,20);
  value->setValue(0);
  value->setBackgroundMode( PaletteMid );
  // connect(value,SIGNAL(valueChanged(int)),SLOT(transp(int)));

  QPushButton * pb = new QPushButton( "do it",this );
  pb->setGeometry(0,60,195,20);
  connect(pb,SIGNAL(pressed()),SLOT(transpose()));
  pb->show();

  QPushButton * ok = new QPushButton( this ); ok->setPixmap( loader->loadIcon("exit.xpm") ); ok->setGeometry(0,80,195,20);


  connect(ok,SIGNAL(pressed()),SLOT(ok()));
  ok->show();

}

void QtTranspose::transpose() {
  if (left) {
    for (KbAtom * atom = left; (atom!=0) && (atom!=right); atom = atom->gNext())
      if (atom->isNote())
	((KbNote*)atom)->sFreq(((KbNote*)atom)->gFreq()+value->value());
    editor->repaint();
  }
}

void QtTranspose::ok() {
  editor->repaint();
  delete this;
}

#endif
