#ifndef _QTWAVETRACK_C_
#define _QTWAVETRACK_C_

#include "kbTrack.h"
#include "qtWaveTrack.h"
#include "kbWaveTrack.h"
#include <iostream.h>
#ifdef HAVE_ARTS
#include "arts.h"
#endif

QtWaveTrack::QtWaveTrack(KbTrack * kbtrack)
  : QtTrack(kbtrack)
{
  /*
  int n = track->trackNum()+1; // the underlying kbTrack of this qtTrack is not registered yet, that's why +1 !
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);
  */

  KIconLoader * loader = kapp->getIconLoader();
  
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute.xpm" ));

  int hh = height();
  mute = new TogBut( 0, track, pmMute, 0, this, "mute" );
  mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  mute->setGeometry(0,0,24,hh+1);

  output = new QComboBox(FALSE,this,"output");
  // output->insertStrList( ((QtMain*)kbtrack->gMain()->gInterface())->gDevList() );
#ifdef HAVE_ARTS
  if (!CORBA::is_nil(KbMain::synthesizer)) {
    Arts::StringSeq_var destinations = KbMain::synthesizer->busList();
    for(int i=0;i<destinations->length();i++)
      output->insertItem((const char *)(*destinations)[i]);
  }
#endif
  // output->setCurrentItem(((KbScoreTrack*)track)->gOutput());
  output->setGeometry(328,0,96,hh+1);
  connect(output,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  type->chooseWave();

}

void QtWaveTrack::updateOut(int i) {
  ((KbWaveTrack*)track)->sOutput(i);
}

void QtWaveTrack::erase() {
  delete this;
}

void QtWaveTrack::update() {
  QtTrack::update();
  mute->update(); track->gMain()->muteTrack(track->trackNum());
  show();
}





#endif
