    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guiwindow.h"
#include "qframe.h"
#include "kiconloader.h"
#include "sequenceutils.h"

static long instances = 0;

void QGuiWindow::closeEvent( QCloseEvent *event )
{
   event->ignore();
}

Gui_WINDOW::Gui_WINDOW()
{
	Widget = 0;
	Layout = 0;
	ParentWidget = 0;
	instances++;
	printf("NOW %ld instances of the panel active\n",instances);
}

Gui_WINDOW::~Gui_WINDOW()
{
	if(Widget) delete Widget;
	instances--;
	printf("NOW %ld instances of the panel active\n",instances);
}

void Gui_WINDOW::widgetDestroyed(QWidget *widget)
{
	assert(Widget == widget);
	Widget = 0;
}

QBoxLayout *Gui_WINDOW::parentLayout()
{
	printf("GW: layout requested\n");
	return Layout;
}

void Gui_WINDOW::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_WINDOW");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"caption",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"id",Arts::output,Arts::audio_data,Arts::stream);

	Broker->publishModule(Server, info);
}

void *Gui_WINDOW::Creator()
{
	return new Gui_WINDOW;
}

ModuleClient MC_Gui_WINDOW(GuiModule::get_MS,"Gui_WINDOW",Gui_WINDOW::Creator);

void Gui_WINDOW::applyParameters(Arts::ModuleDesc *desc)
{
	printf("crw\n");
	if(!Widget)
	{
		QGuiWindow *Window = new QGuiWindow();
		Window->setFrameStyle( QFrame::Panel | QFrame::Raised );
		Window->setLineWidth( 2 );
		Window->resize(0,0);
		xPos = yPos = 0;
		//Frame->setMinimumSize(100,100);
		Widget = Window;
		watchWidget(Widget);
	}

	Layout = new QHBoxLayout(Widget);

	string caption = getStringParam(desc,"caption");
	if(strlen(caption.c_str()))
	{
		Widget->setCaption(caption.c_str());
	}
	idPort = lookupPort(desc,"id");
}

QWidget *Gui_WINDOW::isParent()
{
	return(Widget);
}

void Gui_WINDOW::setParent(QWidget *parent, QBoxLayout *layout)
{
/*
	Don't care about parentsetting at all. We are a window, and that's
	it!
*/
}

void Gui_WINDOW::finalize()
{
	emitSignal(idPort,(float)_GlobalID);
}

void Gui_WINDOW::start()
{
	Widget->show();

	// if present, take position from session management
	if(xPos>=0 && yPos>=0) Widget->move(xPos,yPos);

	Layout->activate();
}

void Gui_WINDOW::restoreSessionParameters(const Arts::StringSeq& params)
{
	unsigned long i;
   	char *cmd,*param;
   	for(i=0;i<params.length();i++)
   	{
   		if(parse_line(params[i],cmd,param))   // otherwise: empty or comment
   		{
   			if(strcmp(cmd,"x") == 0) {
   				xPos = atoi(param);
			} if(strcmp(cmd,"y") == 0) {
   				yPos = atoi(param);
			}
		}
   	}
}

Arts::StringSeq *Gui_WINDOW::saveSessionParameters(list<long>&)
{
	Arts::StringSeq *params = new Arts::StringSeq;

	if(Widget)
	{
		sqprintf(params,"x=%d",Widget->x());
		sqprintf(params,"y=%d",Widget->y());
	}
	return params;
}
