    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _GUI_WINDOW_H
#define _GUI_WINDOW_H

#include "guimodule.h"
#include "qwidget.h"
#include "qlayout.h"
#include "qframe.h"

class Gui_WINDOW :public GuiModule
{
	QWidget *Widget, *ParentWidget;
	QBoxLayout *Layout;
	long idPort;

	int xPos,yPos;
public:
	Gui_WINDOW();
	~Gui_WINDOW();

	void publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker);

	static void *Creator();

	void applyParameters(Arts::ModuleDesc *desc);
	void finalize();
	void start();
	void setParent(QWidget *Parent,QBoxLayout *layout);
	QWidget *isParent();
	QBoxLayout *parentLayout();
	void widgetDestroyed(QWidget *widget);

	Arts::StringSeq *saveSessionParameters(list<long>&);
	void restoreSessionParameters(const Arts::StringSeq& params);
};

// an uncloseable window
class QGuiWindow : public QFrame {
public:
	void closeEvent(QCloseEvent *event);
};
#endif
