/***************************************************************************
                          inputdrop.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Apr 24 1999                                           
    copyright            : (C) 1999 by ROLLY Arnaud                         
    email                : rolly@technologist.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "inputdrop.h"

#include <iostream>
#include <kmsgbox.h>
#include <kurl.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>

InputDrop::InputDrop(QWidget *parent, const char *name ) : KDNDDropZone(parent,DndURL)
{
}

InputDrop::~InputDrop()
{
}

void InputDrop::drop(char *data, int size, int type, int x, int y)
{
	if (type == DndURL)
	{
		QString buffer = data;
    QString file;

		int find = 0;
		
		while (find != -1)
		{
			find = buffer.find('\n');
			file = buffer.left(find);
			file = KURL(file).path();
			if (QFileInfo(file).isFile())
				threatFile(file);
			else
				threatDir(file);
			buffer = buffer.right(buffer.length() - find - 1);
		}
	}
}

void InputDrop::threatFile(QString &s)
{
	QFileInfo fileInfo(s);
	
	if (fileInfo.isFile() && (s.right(3).lower() == "wav"))
		emit(signalMp3Dropped(s));
}

void InputDrop::threatDir(QString &s)
{
	QFileInfo fileInfo(s);
	
	if (fileInfo.isDir())
	{
		QDir dir(s);
		for (unsigned int parse = 0; parse < dir.count(); parse++)
		{
			QFileInfo dirFile(s + dir[parse]);
			if (dirFile.isFile() && (dirFile.absFilePath().right(3).lower() == "wav"))
				emit(signalMp3Dropped(dirFile.absFilePath()));
			//cout << dirFile.absFilePath() << "\n";
			//if (dirFile.isFile() && (s.right(3).lower() == "wav"))
			//	emit(signalMp3Dropped(s + dir[parse]));
		 }
	}
}