/***************************************************************************
                          kblade.cpp  -  description                              
                             -------------------                                         
    begin                : mer avr 14 20:46:47 CEST 1999
                                           
    copyright            : (C) 1999 by ROLLY Arnaud                         
    email                : rolly@technologist.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "encoder.h"
#include "inputdrop.h"
#include "kblade.h"


#include <kfiledialog.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <ktabctl.h>
#include <qbuttongroup.h>
#include <qfileinfo.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qpopupmenu.h>

KBlade::KBlade(QWidget*parent,const char* name):QWidget(parent,name)
{
	container = parent;

	setFixedSize(315, 270);

	errorShow = NULL;

	KTabCtl *tab = new KTabCtl(this);
	tab->setGeometry(5, 5, 305, 225);
	
	QWidget *filesTab = new QWidget(tab);
	mp3Files = new QListBox(filesTab);
	mp3Files->setGeometry(5, 5, 290, 160);
	mp3Files->setMultiSelection(true);
	QPushButton *unselectAll = new QPushButton("Unselect all", filesTab);
	connect(unselectAll, SIGNAL(clicked()), this, SLOT(slotUnselectAll()));
	unselectAll->setGeometry(5, 170, 80, 20);
	QPushButton *selectAll = new QPushButton("Select all", filesTab);
	connect(selectAll, SIGNAL(clicked()), this, SLOT(slotSelectAll()));
	selectAll->setGeometry(95, 170, 80, 20);
	QPushButton *removeSelected = new QPushButton("Remove selected", filesTab);
	connect(removeSelected, SIGNAL(clicked()), this, SLOT(slotRemoveSelected()));
	removeSelected->setGeometry(185, 170, 110, 20);

	InputDrop *mp3Drop = new InputDrop(mp3Files);
	connect(mp3Drop, SIGNAL(signalMp3Dropped(const char *)), this, SLOT(slotNewMp3(const char *)));
	
	QWidget *optionsTab = new QWidget(tab);
	
	QGroupBox *bitrateGrp = new QGroupBox("Bitrate :", optionsTab);
	CHECK_PTR(bitrateGrp);
	bitrateGrp->setGeometry(5, 5, 140, 140);
	bitrate = new QListBox(bitrateGrp, "bitrate");
	CHECK_PTR(bitrate);
	bitrate->setGeometry(10, 20, 120, 110);
	bitrate->insertItem("32");
	bitrate->insertItem("40");
	bitrate->insertItem("48");
	bitrate->insertItem("56");
	bitrate->insertItem("64");
	bitrate->insertItem("80");
	bitrate->insertItem("96");
	bitrate->insertItem("112");
	bitrate->insertItem("128");
	bitrate->insertItem("160");
	bitrate->insertItem("192");
	bitrate->insertItem("224");
	bitrate->insertItem("256");
	bitrate->insertItem("320");
	bitrate->setSelected(8, true);
	bitrate->setBottomItem(10);

	QGroupBox *flags = new QGroupBox("Flags :", optionsTab);
	CHECK_PTR(flags);
	flags->setGeometry(160, 5, 135, 140);
	crc = new QCheckBox("Crc", flags);
	CHECK_PTR(crc);
	crc->setGeometry(10, 15, 80, 20);
	priv = new QCheckBox("Private", flags);
	CHECK_PTR(priv);
	priv->setGeometry(10, 35, 80, 20);
	priv->setChecked(true);
	copyright = new QCheckBox("Copyright", flags);
	CHECK_PTR(copyright);
	copyright->setGeometry(10, 55, 80, 20);
	copyright->setChecked(true);
	
	QButtonGroup *origin = new QButtonGroup(flags);
	CHECK_PTR(origin);
	origin->setGeometry(10, 75, 80, 55);
	original = new QRadioButton("Original", origin);
	CHECK_PTR(original);
	original->setGeometry(5, 5, 70, 20);
	copy = new QRadioButton("Copy", origin);
	CHECK_PTR(copy);
	copy->setGeometry(5, 30, 70, 20);
	original->setChecked(true);
	
	del = new QCheckBox("Delete WAVs automatically", optionsTab);
	CHECK_PTR(del);
	del->setGeometry(5, 150, 200, 20);
	del->setChecked(true);
	mono = new QCheckBox("Force MONO encoding", optionsTab);
	CHECK_PTR(mono);
	mono->setGeometry(5, 170, 200, 20);
	
	recursive = new QCheckBox("Recursive parsing", optionsTab);
	CHECK_PTR(recursive);
	recursive->setGeometry(5, 210, 150, 20);
	
	tab->addTab(filesTab, "Files");
	tab->addTab(optionsTab, "Options");
	
	encode = new QPushButton("Encode", this);
	CHECK_PTR(encode);
	encode->setGeometry(5, 235, 70, 30);
	connect(encode, SIGNAL(clicked()), this, SLOT(slotEncode()));
	
	quit = new QPushButton("Quit", this);
	CHECK_PTR(quit);
	quit->setGeometry(85, 235, 70, 30);
	connect(quit, SIGNAL(clicked()), kapp, SLOT(quit()));
	
	mp3Files->setFocus();
	
}

KBlade::~KBlade()
{
}

void KBlade::slotEncode()
{
	delete errorShow;
	errorShow = NULL;
	container->hide();
	Encoder *enc = new Encoder(this);
	CHECK_PTR(enc);
	enc->show();
	container->show();
}

void KBlade::slotNewMp3(const char *newMp3)
{
	bool alreadyExists = false;
	for (unsigned int parse = 0; parse < mp3Files->count(); parse++)
		if (QString(mp3Files->text(parse)) == QString(newMp3))
			alreadyExists = true;
	if (!alreadyExists)
		mp3Files->insertItem(newMp3);
}

void KBlade::slotInput()
{
/*
	QString fileName = KDirDialog::getDirectory(input->text());
	if (!fileName.isNull())
		if (QFileInfo(fileName).isReadable())
			if (QFileInfo(fileName).isWritable())
				input->setText(fileName);	
			else
				KMsgBox::message(this, "ERROR", "The selected directory is not writable!");
		else
			KMsgBox::message(this, "ERROR", "The selected directory is not readable!");
*/
}

bool KBlade::getRecursiveSearch() const
{
	return (recursive->isChecked());
}

const char *KBlade::getCmdLineBitrate() const
{
	return (bitrate->text(bitrate->currentItem()));
}

const bool KBlade::getCmdLineCrc() const
{
	return (crc->isChecked());
}

const bool KBlade::getCmdLinePrivate() const
{
	return (priv->isChecked());
}

const bool KBlade::getCmdLineCopyright() const
{
	return (copyright->isChecked());
}

const bool KBlade::getCmdLineOriginal() const
{
	return (original->isChecked());
}

const bool KBlade::getCmdLineDelete() const
{
	return (del->isChecked());
}

const bool KBlade::getCmdLineMono() const
{
	return (mono->isChecked());
}

void KBlade::addError(const char *errorMsg)
{
		if (errorShow == NULL)
		{
			errorShow = new ErrorShow();
			CHECK_PTR(errorShow);
			errorShow->show();
		}
		errorShow->addMsg("-----------------------------------------------------");
		errorShow->addError(errorMsg);
}

int KBlade::countErrors()
{
	if (errorShow == NULL)
		return (0);
	else
		return (errorShow->countErrors());
}

int KBlade::countFiles()
{
	return (mp3Files->count());
}

QString KBlade::getFile(int index)
{
	return (QString(mp3Files->text(index)));
}

void KBlade::delFile(int index)
{
	mp3Files->removeItem(index);
}

void KBlade::slotUnselectAll()
{
	for (unsigned int i = 0; i < mp3Files->count(); i++)
		mp3Files->setSelected(i, false);
}

void KBlade::slotSelectAll()
{
	for (unsigned int i = 0; i < mp3Files->count(); i++)
		mp3Files->setSelected(i, true);
}

void KBlade::slotRemoveSelected()
{
	for (unsigned int i = 0; i < mp3Files->count();)
		if (mp3Files->isSelected(i))
			mp3Files->removeItem(i);
		else
			i++;
}