/* Das ist die "Radioklasse", das ist die low-level Steuerung 
 * unseres Radios. Hier sind alle zugriffe auf die Hardware, bzw.
 * die ioctl Steuerung des bttv-devices versammelt.
 * Written Nov 1998 Carsten 
 */

#ifndef RADIOCTRL_H
#define RADIOCTRL_H

#include <asm/types.h>
#include <linux/videodev.h>

// Wir definieren hier unsere Klasse, die die Eigenschaften und
// Steuerfunktionen unseres Radios festhlt.

/**
 * Das ist die Radiocontrollklasse 
 *
 * Radio steuert den Radioteil einer video4linux kompatiblen Bt848 
 * TV Karte. Der Zugriff erfolgt ber /dev/radio und die Steuerung 
 * ber die normalen ioctl die in bttv.h definiert sind.
 *
 * @short Steuerung eine video4linux kompatible Radiokarte
 * @author Carsten Gross (carsten@sol.wohnheim.uni-ulm.de)
 * @version 0.0.1
 */

class Radio {

// Public sind hier nur die Memberfunktionen
public:
	
	Radio(double, int, const char * );
	/** 
	 * Select tuner frequency in MHz
	 *
	 * @see Radio#getFrequenz
	 *
	 * @param Frequenz The frequency in Mhz
	 */
	void   setFrequenz(double Frequenz);  // Frequenz (in MHz) whlen

         /**
          * Get tuner frequency back in MHz
          *
          * @see Radio#setFrequenz
          * @return frequency 
          */
	double getFrequenz(void);             // ans Programm liefern

         /**
          * Set tuner to on and occupies the resources 
          *
          * @see Radio#off
          * @param const char * Device name
          * @return TRUE all okay, FALSE error 
          */
	int    on(const char *);                      // Radio einschalten

	 /**
	  * Switch tuner off and release resources 
	  *
	  * Mutes the tuner and the device file is cloesd. You can use
	  * /dev/radio by another application after calling this.
          *
	  * @see Radio#on 
	  */
        void   off(void);                     // ausschalten und Ressourcen freigeben

          /**
           * Set tuner volume between 0 and 255
           *
           * @see Radio#getVolume
           *
           * @param Volume a value between 0 (off) and 255 (loud)
           */
	void   setVolume(int Volume);         

          /**
           * Read volume value
           *
           * @see Radio#setVolume
           *
           * @return 0 (silence) to 255 (loud)
           */
	int    getVolume(void);

	   /**
	    * Get status (Filedeskriptor auf /dev/radio)
            *
            * @return fd (0 = okay, negative = error as in errno)
            */
        int	getStatus(void) {
        	return fd;
        	};


// Protected sind alle Variablen wo wir uns die Eigenschaften merken
protected:
	double Frequenz;
	bool Status; // ON oder OFF
	int    fd;     // der Filedeskriptor von /dev/bttv-radio,
                       // wird vom Kontruktor gefllt

	struct video_audio hw_audio; // Mssen wir im Konstruktor fllen
				     // braucht man fr ioctl VIDIOCGAUDIO

//private:
//	enum { OFF, ON }; // OFF = 0, ON = 1

};

#endif
