/*
 *              KDERadio - Ein Radioprogramm fr KDE
 *
 * "Geklaut" und verndert von Carsten Gro aus kscd, dem CD Player fr KDE
 * (C) Carsten Gro, carsten@sol.wohnheim.uni-ulm.de
 *     KSCD Code (C) Bernd Johannes Wuebben, wuebben@math.cornell.edu
 *     Es gilt die GPL in Version 2.0
 */

#include "kderadio.h"

#include <qtooltip.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <kwin.h>
#include <kapp.h>
#include <klocale.h>
#include <qmessagebox.h>
#include "docking.h"
#include <iostream.h>

extern KApplication * mykapp;

bool dockinginprogress;

DockWidget::DockWidget(class KRadio *pKRadio, const char *name)
  {
  docked = false;

  assert(pKRadio);

  pkderadio = pKRadio;
  pos_x = pos_y = 0;
  HaveKDERadioPosition = false;
  QString tmp;

  miniKDERadioPixmap = UserIcon("kderadio-dock");

#define PMERROR(pm) \
  tmp.sprintf(klocale->translate("Could not load %s !"), pm); \
  QMessageBox::warning(this,i18n("Error"), tmp);

  //     printf("trying to load %s\n",pixdir.data());
  // load pixmaps

//  if (!miniKDERadioPixmap.load(kapp->miniIcon())){
//    PMERROR("mini/kderadio.xpm");
//  }

  // popup menu for right mouse button
  popup_m = new QPopupMenu();

  nextID = popup_m->insertItem(i18n("Next Station"), this, SLOT( slotIncreaseStation()));
  popup_m->changeItem(nextID, SmallIcon("forward"), i18n("Next Station")); 
	
  prevID = popup_m->insertItem(i18n("Previous Station"), this, \
	SLOT( slotDecreaseStation()));
  popup_m->changeItem(prevID, SmallIcon("back"), i18n("Previous Station"));
  popup_m->insertSeparator();
  currID = popup_m->insertItem(i18n("Current"), this , SLOT(slotDoNothing()) );
  popup_m->insertSeparator();
  toggleID = popup_m->insertItem(i18n("Restore"),
				 this, SLOT(toggle_window_state()));
  popup_m->changeItem(toggleID, SmallIcon("kderadio"), i18n("Restore"));

}

DockWidget::~DockWidget() {
}



// The following code is mainly shamelessly stolen from KSCD :) 
void DockWidget::dock() {

  if (!docked) {


    // prepare panel to accept this widget
    KWin::setSystemTrayWindowFor(this->winId(), this->winId());

    // that's all the space there is
    this->setFixedSize(24, 24);

    // finally dock the widget
    this->show();
    docked = true;
  }
  if(pkderadio){
    QPoint point = pkderadio->mapToGlobal (QPoint (0,0));
    pos_x = point.x();
    pos_y = point.y();

  }
}

void DockWidget::undock() {

  if (docked) {

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough.
    this->destroy(true, true);

    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
    QToolTip::remove(this);

  }
}

const bool DockWidget::isDocked() {

  return docked;

}

void DockWidget::paintEvent (QPaintEvent *e) {

  (void) e;

  paintIcon();

}

void DockWidget::paintIcon () {

  bitBlt(this, 0, 0, &miniKDERadioPixmap);


}

void DockWidget::timeclick() {

  if(this->isVisible()){
    paintIcon();
  }  
}


void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close connect-window on right mouse button 
  if ( e->button() == LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on left mouse button
  if ( e->button() == RightButton  || e->button() == MidButton) {
    int x = -this->x(); // e->x(); // + this->x();
    int y = -this->y(); // e->y(); // + this->y();

    QString text;
    if(pkderadio->isVisible())
      text = i18n("Minimize");
    else
      text = i18n("Restore");
    
    popup_m->changeItem(text, toggleID);
    popup_m->popup(mapToGlobal(QPoint(x, y)));
    popup_m->exec();
  }

}

void DockWidget::toggle_window_state() {
  // restore/hide connect-window
    if(pkderadio != 0L)  {
        if (pkderadio->isVisible()){
            dockinginprogress = true;
            SaveKDERadioPosition();
//            QPoint point = pkderadio->mapToGlobal (QPoint (0,0));
//            pos_x = point.x();
//            pos_y = point.y();
            toggled = true;
            pkderadio->hide();
        }
        else {

            if(!HaveKDERadioPosition)
                SaveKDERadioPosition();

            pkderadio->setGeometry(
                           pos_x,
                           pos_y,
                           pkderadio->width(),
                           pkderadio->height());
            toggled = false;
            //
            QPoint zp = pkderadio->mapToGlobal(QPoint (0,0));
            if(zp.x() == pos_x && zp.y() == pos_y){
                pkderadio->setGeometry(pos_x-4, pos_y-24, pkderadio->width(), pkderadio->height());
            }
            //
            pkderadio->show();
            dockinginprogress = false;
        }
    }
}

const bool DockWidget::isToggled()
{
    return(toggled);
}

void DockWidget::slotDoNothing() {
	return;
}

void DockWidget::setCaptions(KRadio * p) {
	QString Next;
	QString Prev;
	QString Current;

	Next = p->nextStation();
	Prev = p->prevStation();
	Current = p->getStation();

	if (Next != NULL) {
		Next = i18n("Next Station ") + Next;
	} else {
		Next = i18n("Next Station ");
	}
	if (Prev != NULL) {
		Prev = i18n("Previous Station ") + Prev;
	} else {
		Prev = i18n("Previous Station");
	}
	if (Current != NULL) {
		Current = i18n("Current Station ")+ Current;
	} else {
		Current = i18n("Current Station ");
	}
	popup_m->changeItem(prevID, SmallIcon("back"), Prev);
	popup_m->changeItem(currID, Current); 
	popup_m->changeItem(nextID, SmallIcon("forward"), Next);	
	return;
}

void DockWidget::SaveKDERadioPosition()
{
     QPoint point = pkderadio->mapToGlobal (QPoint (0,0));
     pos_x = point.x();
     pos_y = point.y();
     HaveKDERadioPosition = true;
}


void DockWidget::slotIncreaseStation() {

	int i;
	
	i=pkderadio->pStationList->currentItem();
	i++;
	if (i < pkderadio->pStationList->count()) {
		pkderadio->pStationList->setCurrentItem(i);
		pkderadio->slotChangeStation(pkderadio->pStationList->currentText());
	} 
	QToolTip::remove(this);
	QToolTip::add(this, pkderadio->pStationList->currentText());
	return;
}

void DockWidget::slotDecreaseStation() {
	int i;
	
	i=pkderadio->pStationList->currentItem(); 
	i--;
	// i kann eigentlich nicht kleiner -1 werden!
	// Wenn hier ein assert kommt, dann i kontrollieren!
	cerr << i;
	assert( i >= -1 ); 
	if (i < 0) 
		i = 0;
	pkderadio->pStationList->setCurrentItem(i);
	pkderadio->slotChangeStation(pkderadio->pStationList->currentText());
	QToolTip::remove(this);
	QToolTip::add(this, pkderadio->pStationList->currentText());
	return;
}
