/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef MENU_H
#define MENU_H

#include "alarmtimer.h"
#include "jumpDevice.h"
#include "timerDevice.h"
#include "fadeDevice.h"
#include "fadeDeviceGui.h"
#include "songLogger.h"

#include "../config.h"
#include "songList.h"
#include "songTree.h"
#include "configfolder.h"
#include "ioaccess.h"
#include "songInfo.h"
#include "mainwidget.h"
#include "database.h"
#include "printer.h"

#include "amplifier/amplifier.h"
#include "devices/multicastDevice.h"
#include "devices/mixerDevice.h"
#include "devices/audioDevice.h"
#include "devices/multicastDevice.h"
#include "devices/volumeDevice.h"
#include "deviceConfig/info/timeInfo.h"
//#include "timerWidget.h"

//#include "timer.h"
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kfiledialog.h>
#include <kaccel.h>
#include <drag.h>
#include <qstring.h>
#include <qscrollbar.h>
#include <qpopupmenu.h>

#define ID_MAIN_TOOLBAR   0
#define ID_NEW            1
#define ID_OPEN           2
#define ID_SAVE           3
#define ID_PRINT          4
#define ID_HELP           5
#define ID_COPYSELECTION  6 
#define ID_COPYALL        7 
#define ID_REMOVE         8 
#define ID_REMOVEPLAYED   9
#define ID_CLEARPLAYLIST 10
#define ID_SHUFFLE       11

#define ID_SOUND1_TOOLBAR 1
#define ID_SOUND2_TOOLBAR 2
#define ID_PLAY           13
#define ID_PAUSE          14
#define ID_STOP           15
#define ID_FADE           16
#define ID_JUMPDEVICE     18
#define ID_VOLUME         19
#define ID_COUNTDOWN      20
#define ID_LEFT_ARROW     21
#define ID_PLAYER_TEXT    22

#define ID_SHOWINFO       23
#define ID_PLAYIT         24

#define ID_LOGFILE        25

#define PLAYER1 0
#define PLAYER2 1

class ApplicationWindow: public KTMainWindow{
  Q_OBJECT
 private:  
  KConfig       *config;
  KMenuBar      *menu;
  KStatusBar    *status;
  QString        fileDialogPath;
  KAccel        *keys;

  QScrollBar    *volumeBar;
  QPopupMenu    *controls;
  QPopupMenu    *genre;
  QPopupMenu    *sort;
  QPopupMenu    *openRecent;
  QPopupMenu    *songMenu;
  Configuration *settings;
  MainWidget    *mainWidget;
  bool           settingsUp;
  IOAccess       ioaccess;
  QPixmap       *leftArrow;
  QPixmap       *rightArrow;
  DataBase      *dataBase;
  Printer       *printer;
  Song          *currentSong;
  SongLogger    *songLogger;

  GenericPlayer    **decoder;
  VolumeDevice     **volumeDevice;
  MulticastDevice  **multicastDevice;
  AudioStreamInfoDevice **streamTimeInfoDevice;
  AudioStreamInfoDevice **streamAlarmInfoDevice;
  TimerDevice      **timer;
  AlarmTimer       **alarmtimer;
  FadeDevice       **fadeDevice;
  AudioDevice      *audioDevice;
  MixerDevice      *mixerDevice;  
  JumpDevice       **jumpDevice;
 
  QString *playingSongName;
  int      playerStatus;
  int      sb, stb, mtb;
  bool    *pausing;
  bool    *playing;
  QString  title;
  QString  dateiName;  
  bool     shufflePlaying;


  void setTitle();
  void initMenuBar();
  void initSoundToolbar(int );
  void initMainToolbar();
  void initializePlayer();
  void slotSoundToolbarClicked(int, int );
  void refreshSoundToolBar(int);
  void removePlayer(int player);
  void createPlayer(int player);
  void refreshRecentlyOpenFileDialog();
  void restartDecoder(int player);
  void initCommandLineParameter();
  void initAccelKeys();

 protected:
  void resizeEvent (QResizeEvent *);
  bool eventFilter(QObject* object,QEvent *e);

 public:
  ApplicationWindow();
  ~ApplicationWindow();

 signals:

 public slots:
  void neu();
  void laden();
  void laden( const char *dateiName );
  void importMP3Datei();
  void importMP3Liste();
  void importM3uListe();
  void exportMP3Liste();
  void exportM3uListe();
  void speichern();
  void speichern(QString ); 
  void speichernAls();
  void hilfe();
  void ueberkjukebox();
  void genreChanged(int);
/*    void drop(KDNDDropZone *); */

  void playNextSong1();
  void playNextSong2();
  void playNextSong(int );
  void playSelectedSong();
  void playSong(int , Song *);
  void playNext(int );
  void player1Pause();
  void player2Pause();
  void playerPause(int );
  void player1Stop();
  void player2Stop();
  void playerStop(int );
  void setAudioDevice();

 private slots:
  void print();
  void printerSettings();
  void printerPreview();
  void playSelectedSong(Song *);
  void addRecentFile(QString filename);
  void refreshOpenRecentFileDialog();
  void openRecentFile(int id);
  void slotSoundToolbar1Clicked(int );
  void slotSoundToolbar2Clicked(int );
  void slotMainToolbarClicked(int );
  void toggleShufflePlaying();
  void keySettingsOpen();
  void settingsOpen();
  void settingsDestroyed();
  void setGenreMenu();
  void setSortOrder(int order);
  void toggleStatusBar();
  void toggleMainToolBar();  
  void toggleSoundToolBar();  
  void setStatus(int );
  void showError(int );
  void refresh();
  void decoderStopedPlaying(int );
  void decoderCrashed(int );
  void decoder1Event(char );
  void decoder2Event(char );
  void decoderEvent(int ,char );
  void timerAlarm(int );
  void timer1Alarm();
  void timer2Alarm();
  void jumpOnPlayer1(int Seconds);
  void jumpOnPlayer2(int Seconds);
  void jump(int player, int Seconds);
  void quitKJukeBox();
  void fadeOut1Ready();
  void fadeOut2Ready();
};
#endif // MENU_H


