/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <klined.h>
#include "configAbout.h"

ConfigAbout::ConfigAbout(QWidget *parent, const char *name)
    : QWidget (parent,name)
{
  box = new QGroupBox(this,"box");
  logo      = new QLabel(box, "logo");
  copyright = new QLabel(box, "copyright");
  author    = new QLabel(box, "author");
  hometext  = new QLabel(box, "hometext");

#include <pics/kjukebox_logo.xpm>
  logoPix   = new const QPixmap((const char **)kjukebox_logo_xpm);
  logo->setPixmap(*logoPix );

  QString text;
  text.sprintf("KJukeBox v%s\nCopyright (c) 1999",(const char *)VERSION);
  copyright->setText(text);
  copyright->setAlignment(AlignCenter|WordBreak);

  text.sprintf("Rainer Maximini\nr_maximi@informatik.uni-kl.de");
  author->setText(text);
  author->setAlignment(AlignCenter|WordBreak);

  text = i18n("Visit the KJukeBox Homepage for bugfixes or new versions at");
  text += i18n("\nhttp://third.informatik.uni-kl.de/ ~rainer/KJukeBox/index.html");
  hometext->setText(text);
  hometext->setAlignment(AlignCenter|WordBreak);
}

ConfigAbout::~ConfigAbout(){
  delete(logoPix);
}

void ConfigAbout::resizeEvent( QResizeEvent * ){
  box->setGeometry(10,10,width()-20,height()-20);
  logo->setGeometry(15, 30, logoPix->width(), logoPix->height());
  copyright->setGeometry(logoPix->width()+30, 30,
			box->width()-(logoPix->width()+30+15), logo->height());
  author->setGeometry(15,logo->height()+45,box->width()-30,60);
  hometext->setGeometry(10,box->height()-110,box->width()-20,100);
}

void ConfigAbout::cancel(){}

void ConfigAbout::accept(){}



