/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef CONFIGFILE_H
#define CONFIGFILE_H

#include <kconfig.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qstring.h>
#include <klined.h>
#include <qdialog.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include "configfolder.h"
#include "song.h" /*For the default Settings */

class ConfigFile: public QWidget
{
    Q_OBJECT
 public:
  ConfigFile(QWidget *parent=0, const char *name=0);
 protected:
  void resizeEvent (QResizeEvent *);
 private:  
  KConfig *config;
  QGroupBox *boxImport;
  QLabel *label1, *label2, *label3,*label4,*label5,*label6,*label7,
    *label12,*label13,*label14, *label19,*label20,*label21,*label22,*label23,
    *labelTrenn;
  QPushButton *defaultButton;
  KLined *edit, *editTrenn;
  QString format;
  QString trennzeichen;

  QGroupBox *boxSave;
  QLabel    *useMP3CommentFieldLabel;
  QCheckBox *useMP3CommentFieldBox;
  bool       useMP3CommentField;

  QGroupBox *boxLoad;
  QLabel    *checkFilesLabel;
  QCheckBox *checkFilesBox;
  bool       checkFiles;

 private slots:
  void setDefault();
 public slots:
  void cancel();
  void accept();
};

#endif // EINSTELLUNGEN_H

