/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <qwidget.h>
#include "configfolder.h"

Configuration::Configuration()
    : QObject () {
  tabdialog = new QTabDialog(0,"tabdialog",TRUE);
  tabdialog->setCaption(i18n("KJukeBox Configuration") );
  tabdialog->resize( 400, 505 );
  tabdialog->setMinimumSize(400,505);
  tabdialog->setCancelButton();

  import  = new ConfigFile( tabdialog, "file" );
  about   = new ConfigAbout( tabdialog, "about" );
  player  = new ConfigPlayer( tabdialog, "player" );
  gui     = new ConfigGui ( tabdialog, "gui" );
  general = new ConfigGeneral( tabdialog, "general" );


  connect(player,SIGNAL(audioDeviceChanged()), this, SIGNAL(audioDeviceChanged()));

  
  tabdialog->addTab(import,  i18n("Files") );
  tabdialog->addTab(player,  i18n("Player"));
  tabdialog->addTab(gui,     i18n("Gui") );
  tabdialog->addTab(general, i18n("General") );
  tabdialog->addTab(about,  i18n("About"));
  tabdialog->setOKButton(i18n("OK"));
  tabdialog->setCancelButton(i18n("Cancel"));
  tabdialog->setApplyButton(i18n("Accept"));
  connect(tabdialog,SIGNAL(applyButtonPressed()),this,SLOT(acceptConfig()));
  connect(tabdialog,SIGNAL(cancelButtonPressed()),this,SLOT(cancelConfig()));
}

Configuration::~Configuration(){
  disconnect(tabdialog, 0, this, 0);
  disconnect(tabdialog, 0, this, 0);
  delete import;
  delete about;
  delete player;
  delete gui;
  delete general;
}

void Configuration::acceptConfig(){
  import  ->accept();
  player  ->accept();
  gui     ->accept();
  general ->accept();
  emit configurationChanged();
}

void Configuration::cancelConfig(){
  import  ->cancel();
  player  ->cancel();
  gui     ->cancel();
  general ->cancel();
}

void Configuration::toggleVisible(){
  if(tabdialog->isVisible())
    tabdialog->hide();
  else {
    tabdialog->show();
  }
}



