/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef IOACCESS_H
#define IOACCESS_H

#include "database.h"
#include <iostream.h>
#include <qstring.h>
#include <kprogress.h>
#include <qfile.h>
#include "mp3.h"
#include "kjukebox.h"

class IOAccess {
 private:
  MP3 mp3;
  char helpstring[1000];
  KProgress *progressBar;

  Song loadMP3File(QString);
 
 public:
  IOAccess();

  QSongList load(QString);
  bool save(QString, QSongList);

  QSongList importDirectory(QString);
  Song importMP3File(QString);

  QSongList importMP3FileList(QString);
  bool exportMP3List(QString, QSongList);

  QSongList importM3uFileList(QString);
  bool exportM3uList(QString, QSongList);
};
   
#endif // IOACCESS_H



