/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "database.h"
#include <qobject.h>
#include <iostream.h>
#include <qprogressdialog.h> 

/* sort order: Artist -> Album -> Title */
int QSongListByArtist::compareItems ( GCI item1, GCI item2 ){
  return strcmp(((Song*)item1)->getArtistAlbumTitle(),
		((Song*)item2)->getArtistAlbumTitle());
}

/* sort order: Title -> Artist -> Album*/
int QSongListByTitle::compareItems ( GCI item1, GCI item2 ){
  return strcmp(((Song*)item1)->getTitleArtistAlbum(),
		((Song*)item2)->getTitleArtistAlbum());
}

QGenreSet::QGenreSet( QObject *parent=0, const char *name=0 )
  : QObject(parent,name) {
}

QGenreSet::~QGenreSet(){}

void QGenreSet::insert(QSongList *list){
  static QString prevGenre="";
  Song *song;
  QString genre;
  for(song=list->first(); song!=NULL; song=list->next()){
    genre = song->getGenre();
    if (strcmp(prevGenre,genre)==0) continue ;
    
    if (find(genre)==-1){
      QString *tmp = new QString();
      *tmp = genre;
      append(tmp);
      prevGenre = genre;
    }
  }
  emit changed();  
}

void QGenreSet::insert(Genre genre){
  static QString prevGenre="";
  if (strcmp(prevGenre,genre)==0) return ;
  if (find(genre)==-1){
    QString *tmp = new QString();
    *tmp = genre;
    append(tmp);
    prevGenre = genre;
    emit changed();
  }
}

int QGenreSet::find(Genre genre){
  QString *lauf;
  int index=-1;
  for(lauf=first(); lauf!=NULL; lauf=next()){
    index++;
    if(strcmp(*lauf,genre) == 0) return index;
  }
  return -1;
}
