/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef MP3_TAG_H
#define MP3_TAG_H


#define _MAX_GENRE 148


/* ID3 TAG Format, Space-filled (grr) */

typedef struct {
    char tag[3];
    char title[30];
    char artist[30];
    char album[30];
    char year[4];
    char comment[30];
    unsigned char genre;
} tag;



class Tag {
 private:
  static const char * const genres[];
  static const char * const genresSorted[];
  void safecopy(char* , char* , int );
  void spacecopy(char *, char *, int );
 public:
  char title[31];
  char artist[31];
  char album[31];
  char year[5];
  char comment[31];
  char genre[31];
  int gennum;

  Tag();
  void clear();
  bool scan(FILE * file);
  bool saveTags(FILE * file);
  void setGenreName(char *genreName);
  void setGenreNumber(int genreNumber);
  static int  getMaxGenres();
  static const char* getGenreAsString(int genreNumber);
  static int getGenreAsNumber(const char*  genreName);
  static const char* getSortedGenreAsString(int genreNumber);
  static int getSortedGenreAsNumber(const char*  genreName);
};


#endif
