/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef TIMERDEVICE_H
#define TIMERDEVICE_H


#include <qpainter.h>
#include <qwidget.h>


#include <devices/audioStreamInfoDevice.h>

#include "lcdBitmap.h"

#define _TIMEMODE_PLAYED             100
#define _TIMEMODE_REMAIN             101     


class TimerDevice : public QWidget {
  Q_OBJECT

 private:
  Buffer    *timeString;
  LCDBitmap *lcd;
  int        mode_cfg;
  int        currentSeconds;
  int        timerId;
  AudioStreamInfoDevice* streamInfoDevice;

  char* getTimeString();
  void  createTimeFormat(int played,int len,Buffer* dest);
  void  repaintTime();
  void  repaintTime(char *time);
  void  startRepaintTimer();
  void  stopRepaintTimer();

 public:
  TimerDevice( QWidget *parent=0, const char *name=0 );
  ~TimerDevice();
  void attachTo(AudioStreamInfoDevice* streamInfoDevice);
  void detach();
  int  getTimeMode();
  QSize sizeHint ();

 protected:
  void mousePressEvent ( QMouseEvent* mouseEvent);
  void timerEvent( QTimerEvent * );
  void resizeEvent(QResizeEvent *);
  void paintEvent ( QPaintEvent * ) ;

 public slots:
  void setTimeMode(int mode);
  void toggleTimeMode();

 private slots:
  void playerStatusChanged(char );


};


#endif TIMERDEVICE_H
