
/**
   Notice:

   This file is taken from eMusic, a mp3 player by 
   Isaac Richards <ijr@po.cwru.edu>.

   After a few modifications this interface now is
   incompatible to the eMusic interface.

*/



#ifndef __COMMON_H
#define __COMMON_H



#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

typedef struct {
   char song[31];
   char artist[31];
   char album[31];
   char year[5];
   char comment[31];
   int genre;
} ID3Tag;

struct playlist_item {
  char name[256];
  char path[256];
  int length;
  int pos;
  ID3Tag tag;
  int type;
  struct playlist_item *next;
  struct playlist_item *prev;
};

typedef struct {
  struct playlist_item *first;
  struct playlist_item *last;
  int length;
} PlayList;                          



#define _STREAM_STATE_EOF     1
#define _STREAM_STATE_NOT_EOF 2



struct player_plugin {
   void (*construct)(void);
   void (*destruct)(void);
  
   int (*open)(char* path);
   void (*close)();

   void (*seek)(int second);
   void (*play)();
   void (*pause)(void);
   int (*getStreamState)(void);

   void (*getMusicInfo)(struct playlist_item *song);
   void (*getModuleInfo)(char *id, char *version, char *copyright);

   void (*config)(char *left, char *right);

  
};

#ifdef __cplusplus
extern "C" {
#endif
	
extern int setup_audio(int frequency, int stereo, int sign, int big, int sixteen);
extern void set_bitrate(int bit);
extern void close_audio(void);
extern void flush_audio(void);
extern int parsebool(char *data);
extern int audio_play(char *buffer, int size);
extern int enterMessage(char* msg);
#ifdef __cplusplus
}
#endif



#endif
