/* MPEG/WAVE Sound library

   (C) 1997 by Woo-jae Jung */

// Binput.cc
// Inputstream from file

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include "mpegsound.h"

/************************/
/* Input bitstrem class */
/************************/
Soundinputstreamfromfile::Soundinputstreamfromfile() {
}




Soundinputstreamfromfile::~Soundinputstreamfromfile() {
  if(fp)fclose(fp);
}

bool Soundinputstreamfromfile::open(char *filename)
{
  struct stat buf;

  if(filename==NULL)
  {
    fp=stdin;
    size=0;
    return true;
  }
  else if((fp=fopen(filename,"r"))==NULL)
  {
    seterrorcode(SOUND_ERROR_FILEOPENFAIL);
    return false;
  }

  stat(filename,&buf);
  size=buf.st_size;

  return true;
}

int Soundinputstreamfromfile::getbytedirect(void)
{
  int c;

  if((c=getc(fp))<0) {
    seterrorcode(SOUND_ERROR_FILEREADFAIL);
  }
  return c;
}

bool Soundinputstreamfromfile::_readbuffer(char *buffer,int size)
{
  if (size < 0) {
    seterrorcode(SOUND_ERROR_FILEREADFAIL);
    return false;
  }
  if(fread(buffer,size,1,fp)!=1)
  {
    seterrorcode(SOUND_ERROR_FILEREADFAIL);
    return false;
  }
  return true;
}

bool Soundinputstreamfromfile::eof(void) {
  int back=feof(fp);
  if (back < 0) {
    perror("Soundinputstreamfromfile::eof:");
  }
  return back;
};

int Soundinputstreamfromfile::getblock(char *buffer,int size)
{
  if (size < 0) {
    return false;
  }
  if(fread(buffer,size,1,fp)!=1)
  {
    return false;
  }
  return true;
}


int Soundinputstreamfromfile::getsize(void)
{
  return size;
}

int Soundinputstreamfromfile::setposition(int pos)
{
  if(fp==stdin)return -1;
  if (pos > size) {
    pos = size;
  }
  return fseek(fp,pos,SEEK_SET);
}

int  Soundinputstreamfromfile::getposition(void)
{
  if(fp==stdin)return 0;
  return ftell(fp);
}

