

/*
  generic Implementation of a cd-player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <yafxplayer/inputDecoderXPlayer.h>
#include "../../../../../config.h"

//define DEBUG cout << "Command:1 Msg:"


InputDecoderXPlayer::InputDecoderXPlayer() : InputDecoder() {

  output=new OutputInterface(&cout);
  output->setProtocolSyntax(true);

  ct=new CommandTableXPlayer();
  
  setDecoderStatus(_DECODER_STATUS_IDLE);
  appendCommandTable(ct);
  majorMode=_PLAYER_MAJOR_MODE_OFF;
  setRuntimeInfo(false);
  // As default we expect a user which does not want to know
  // about the player status.
  // This is *not* true if the user is a controlling GUI.
  // A GUI should alwas send :
  // "MajorModeInfo on"
  setMajorModeInfo(true);   // as default we don't inform about the state!
  isOn=false;
} 

InputDecoderXPlayer::~InputDecoderXPlayer(){
  delete ct;
  delete output;
}

void InputDecoderXPlayer::setMajorModeInfo(int lDisplayMajorMode) {
  this->lDisplayMajorMode=lDisplayMajorMode;
}

int InputDecoderXPlayer::getMajorModeInfo() {
  return lDisplayMajorMode;
}



int InputDecoderXPlayer::getOn() {
  return isOn;
}

 
void InputDecoderXPlayer::setOn(int lOn) {
  isOn=lOn;
}




  
void InputDecoderXPlayer::setMajorMode(int mode) {
  char* ptr;
  majorMode=mode;

  if (lDisplayMajorMode==false) {
    return;
  }
  output->lock();
  output->clearBuffer();
  output->appendBuffer("Command:0 Msg:player-status ");
  if (majorMode == _PLAYER_MAJOR_MODE_OFF) {
    ptr="off";
  } else if (majorMode == _PLAYER_MAJOR_MODE_ON) {
    ptr="on";
  } else if (majorMode == _PLAYER_MAJOR_MODE_OPEN_TRACK) {
    ptr="open";
  } else if (majorMode == _PLAYER_MAJOR_MODE_CLOSE_TRACK) {
    ptr="close";
  } else if (majorMode == _PLAYER_MAJOR_MODE_PLAYING) {
    ptr="playing";
  } else if (majorMode == _PLAYER_MAJOR_MODE_PAUSE) {            
    ptr="pause";
  } else {
    ptr="unknown";
  }
  output->appendBuffer(ptr);
  if (majorMode == _PLAYER_MAJOR_MODE_OFF) {
    char val[40];
    long bytes=StreamWriter_getBytesCounter();
    long allWrite=StreamWriter_getAllWriteCounter();
    
    snprintf(val,40,"%ld %ld",bytes,allWrite);
    output->appendBuffer(" ");
    output->appendBuffer(val);
  }
  output->flushBuffer();  
  output->unlock();
}



int InputDecoderXPlayer::getMajorMode() {
  return majorMode;
}



void InputDecoderXPlayer::doSomething(){
  debugOutput( cout << "Decoder did something" << endl );
  // after decoding is ready we close the file

  InputDecoder::doSomething();
}



char* InputDecoderXPlayer::processCommand(int command,char* args){

  if (command == _PLAYER_OFF) {
    if (isOn == true) {
      isOn=false;
      processCommand(_PLAYER_PAUSE,"");
      processCommand(_PLAYER_CLOSE,"");
     
      setMajorMode(_PLAYER_MAJOR_MODE_OFF);
      StreamWriter_setBytesCounter(0);
    }
    return"";
  }
  
  if (command == _PLAYER_ON) {
    if (isOn == false) {
      setMajorMode(_PLAYER_MAJOR_MODE_ON);
      isOn=true;
    }
    return"";
  }


  if (command == _PLAYER_OPEN) {
    setMajorMode(_PLAYER_MAJOR_MODE_OPEN_TRACK);
    return"";
  }
  
  if (command == _PLAYER_CLOSE) {
    setMajorMode(_PLAYER_MAJOR_MODE_CLOSE_TRACK);
    return"";
  }
 
  if (command == _PLAYER_PLAY) {
    setDecoderStatus(_DECODER_STATUS_WORKING);
    setMajorMode(_PLAYER_MAJOR_MODE_PLAYING);
    return"";
  }
 
  if (command == _PLAYER_PAUSE) {
    setMajorMode(_PLAYER_MAJOR_MODE_PAUSE);
    return"";
  }   

  if (command == _PLAYER_VERBOSE) {
    if (strcmp(args,"off")==0) {
      setMajorModeInfo(false); 
    } else {
      setMajorModeInfo(true); 
    }
    return"";
  } 

  if (command == _PLAYER_OUTPUTFILE) {
    int ret;
    if (StreamWriter_isOpenStream() == true) {
      return "already output file selected";
    }    
    StreamWriter_setStreamFile(args);
    // now we have set the fifo. But we must say the parent
    // process that we start with waiting

    debugOutput( cout << "Command:0 Msg:fileopen before"<<endl );
    ret=StreamWriter_openStream();
    debugOutput( cout << "Command:0 Msg:fileopen after"<<endl );

    if (ret < 0) {
      return "cannot open outfile";
    }
    return "";
  }
  if (command == _PLAYER_CLOSEOUTPUTFILE) {
    if (StreamWriter_isOpenStream() == false) {
      return "no output file selected";
    }
    StreamWriter_closeStream();
    return "";
  }

  if (command == _PLAYER_INTERNALAUDIO) {
    if (strcmp("on",args)==0) {
      StreamWriter_internalDevice(true);
      return "";
    }
    StreamWriter_internalDevice(false);
    return "";
  }
   
  if (command == _PLAYER_SLEEP) {
    int nSec;
    sscanf(args,"%d",&nSec);  // convert string to int
    sleep(nSec);
    return "";
  }
  
  return InputDecoder::processCommand(command,args);
}









