/*
  generic audiodevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/audioDevice.h>
#include "../../../../config.h"



AudioDevice::AudioDevice(const char* device):OutputDevice("AudioDevice") {
  audioWrapper=new AudioWrapper();
  audioInfo=new AudioInfo();
  volumeInfo=new VolumeInfo();
  statusInfo=new StatusInfo();
  audioInfo->setDevice(device);
  lneedInit=true;
  lAutoInit=true;
  lEnabled=true;
}


AudioDevice::~AudioDevice() {
  close();
  delete audioWrapper;
}


char* AudioDevice::getNodeName() {
  return "AudioDevice";
}

int AudioDevice::open(const char *device) {
  audioInfo->setDevice(device);   
  return open();
}

int AudioDevice::open(){
  int back=audioWrapper->open(audioInfo->getDevice());
  return back;
}

int AudioDevice::isOpen() {
  return audioWrapper->isOpen();
}


int AudioDevice::close() {
  audioWrapper->close();
  return true;
}


int AudioDevice::init(int sampleSize,int speed,int stereo) {
  audioInfo->setStereo(stereo);
  audioInfo->setSampleSize(sampleSize);
  audioInfo->setSpeed(speed);
  return init(true);
}


int AudioDevice::init(int lForceSet) {
  int stereo=audioInfo->getStereo();
  int sampleSize=audioInfo->getSampleSize();
  int speed=audioInfo->getSpeed();
  if (isOpen() == false) {
    return false;
  } 
  if (lForceSet) {
    debugOutput( cout << "UserInitDSP-> stereo:" << stereo << "sample:"<< sampleSize  << "speed: "<< speed  <<endl );
    audioWrapper->init(sampleSize,speed,stereo);
    return true;
  }
  if (lAutoInit) {
    debugOutput( cout << "AutoInitDSP-> stereo:" << stereo << "sample:"<< sampleSize  << "speed: "<< speed  <<endl );    
    audioWrapper->init(sampleSize,speed,stereo);
    return true;
  } 
  return false;
}


int AudioDevice::getAutoInit() {
  return lAutoInit;
}

void AudioDevice::setAutoInit(int lAutoInit) {
  this->lAutoInit=lAutoInit;
  if (lAutoInit == true) {
    lneedInit=true;
  }
}


StatusInfo* AudioDevice::getStatusInfo() {
  return statusInfo;
}


void AudioDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  if (lEnabled == false) {
    return;
  }
  AudioStream* audioStream=config->getAudioStream();
  AudioBuffer* buffer=audioStream->getAudioBuffer();
  MemChunk* memChunk=buffer->getMemChunk();
  StatusInfo* statusInfoStream=audioStream->getStatusInfo();
  AudioInfo* audioInfoStream=audioStream->getAudioInfo();
  VolumeInfo* volumeInfoStream=audioStream->getVolumeInfo();

  // We ignore statusChange messages, because otherwise
  // it is possible that we initialize /dev/dsp with "strange"
  // values. (Linux ignores this FreeBSD hangs)
  if (statusInfoStream->getChange()) {
    statusInfoStream->copyTo(statusInfo);
    if (statusInfoStream->getStatus()==_STATUS_STOPPED) {
      getEventQueue()->sendEvent(_AUDIODEVICE_CLOSE_REQUEST);
    }
    return;
  }
  if (!(audioInfoStream->equals(audioInfo)) || lneedInit) {
    audioInfoStream->copyTo(audioInfo);
    init(false);
  }
  if (!(volumeInfoStream->equals(volumeInfo)) || lneedInit) {
    float leftVolume=volumeInfoStream->getLeftVolume();
    float rightVolume=volumeInfoStream->getRightVolume();
    volumeInfoStream->copyTo(volumeInfo);
    if (audioWrapper->isOpen()) {
      audioWrapper->setVolume(leftVolume,rightVolume);
    }
  }
  lneedInit=false;
  if (audioWrapper->isOpen()) {
    if (memChunk != NULL) {
      if (memChunk->getLen() > 0) {
	int didWrite=rawWrite(memChunk->getPtr(),memChunk->getLen());
	if (didWrite == -1) {
	  perror("********* write in AudioDevice");
	}
	if (didWrite != memChunk->getLen()){
	  lneedInit=true;
	}
      } else {
	debugOutput( cout << "memChunk len is 0"<<endl);
      }
    } else {
      debugOutput( cout << "memChunk is NULL!"<<endl );
    }
  } else {
    getEventQueue()->sendEvent(_AUDIODEVICE_CANNOT_OPEN);
    NodeDevice::doSleep(500);
    lneedInit=true;
  }
}
  



int AudioDevice::rawWrite(char* buf,int len) {
  return audioWrapper->write(buf,len);
}






int AudioDevice::getEnabled() {
  return lEnabled;
}


void AudioDevice::setEnabled(int lEnable) {
  // block the device for a short time
  writeInLock();
  this->lEnabled=lEnable;
  if ((isOpen() == true) && (lEnabled==false)) {
    close();
  }
  writeInUnlock();
}

