/*
  delivers general status/info messages of the stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __STREAMINFODEVICE_H
#define __STREAMINFODEVICE_H



#include <devices/outputDevice.h>

// Note: event "1" is set in outputDevice !!

#define _AUDIOSTREAMINFO_STATUS_CHANGE          2
#define _AUDIOSTREAMINFO_MUSIC_CHANGE           4
#define _AUDIOSTREAMINFO_TIME_CHANGE            8
#define _AUDIOSTREAMINFO_BUFFERFILL_CHANGE     16
#define _AUDIOSTREAMINFO_AUDIO_CHANGE          32



/**
   The StreamInfoDevice makes life a bit easier. It stores
   all possible informations about the stream. It sends
   special updates Events if one of these Infomation changes.
   <p>
   Note:
   <p>
   Not all of these information must carry uesful data. Eg:
   Sometimes the length (in time) of the stream may be unknown!
   <p>
   A user of this class can set the eventMask for the device.
   <p>
   e.g:
   setEventMask(_STREAMINFO_STATUS_CHANGE || _STREAMINFO_TIME_CHANGE);
   <p>
   sends Status and Time change events.<p>
   The default is: send all events
*/


class AudioStreamInfoDevice : public OutputDevice {

  int eventMask;
  StatusInfo* statusInfo;
  MusicInfo* musicInfo;
  TimeInfo* timeInfo;
  AudioInfo* audioInfo;
  AudioBuffer* audioBuffer;

 public:
  AudioStreamInfoDevice();
  ~AudioStreamInfoDevice();

  char* getNodeName();

  StatusInfo* getStatusInfo();
  MusicInfo* getMusicInfo();
  TimeInfo* getTimeInfo();
  AudioInfo* getAudioInfo();
  AudioBuffer* getAudioBuffer();


  void setEventMask(int mask);
  int getEventMask();

  void writeIn(NodeDevice* source,DeviceConfig* buf);

};


#endif
