/*
  stores StreamProducers and takes care that they work step by step
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <graph/daisyChain.h>
#include "../../../../config.h"


DaisyChain::DaisyChain() {
  int i;

  pthread_mutex_init(&changeMut,NULL);
  pthread_mutex_init(&daisyMut,NULL);

  pthread_cond_init(&daisyCond,NULL);

  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    daisyChain[i]=new DaisyChainElement();
    daisyChain[i]->valid=false;
    daisyChain[i]->locks=0;
  }

  for(i=0;i<_MAX_LOCKS;i++) {
    lockTupel[i]=new LockTupel();
    lockTupel[i]->valid=false;
  }
  lProducerAlreadyLocked=false;
}


DaisyChain::~DaisyChain() {
  int i;

  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    delete daisyChain[i];
  }
  for(i=0;i<_MAX_LOCKS;i++) {
    delete lockTupel[i];
  }

}


void DaisyChain::addElement(StreamProducer* element) {
  int i;

  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==false) {
      daisyChain[i]->valid=true;
      daisyChain[i]->element=element;
      daisyChain[i]->locks=0;
      return;
    }  
  }
  
}


void DaisyChain::removeElement(StreamProducer* element) {
  int i;

  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid == true) {
      if (daisyChain[i]->element==element) {
	daisyChain[i]->valid=false;
	// now remove the locks from our lockholders.

	for(i=0;i<_MAX_LOCKS;i++) {
	  if (lockTupel[i]->valid==true) {
	    if (lockTupel[i]->to==element) {
	      removeLock(lockTupel[i]->from,element);
	    }
	  }
	}
	return;
      }    
    }
  }
}


void DaisyChain::lockDaisyChain() {
  pthread_mutex_lock(&changeMut);
  pthread_mutex_lock(&daisyMut);  
  lProducerAlreadyLocked=true;
}


void DaisyChain::unlockDaisyChain() {
  lProducerAlreadyLocked=false;
  pthread_cond_signal(&daisyCond);
  pthread_mutex_unlock(&changeMut);
  pthread_mutex_unlock(&daisyMut);
}


void DaisyChain::lockStreamProducer() {
  int i;
  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==true) {
      (daisyChain[i]->element)->writeInLock();
      (daisyChain[i]->element)->writeOutLock();
    }  
  }
}


void DaisyChain::unlockStreamProducer() {
  int i;

  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==true) {
      (daisyChain[i]->element)->writeOutUnlock();
      (daisyChain[i]->element)->writeInUnlock();
    }  
  }
}




void DaisyChain::addLock(void* from,StreamProducer* to) {
  int i;

  for(i=0;i<_MAX_LOCKS;i++) {
    if (lockTupel[i]->valid==false) {
      lockTupel[i]->from=from;
      lockTupel[i]->to=to;
      lockTupel[i]->valid=true;
      incLock(lockTupel[i]->to);
      return;
    }
     
  }
}


void DaisyChain::removeLock(void* from,StreamProducer* to) {
  int i;

  for(i=0;i<_MAX_LOCKS;i++) {
    if (lockTupel[i]->valid==true) {
      if (lockTupel[i]->from==from) {
	if (lockTupel[i]->to==to) {
	  lockTupel[i]->valid=false;
	  decLock(lockTupel[i]->to);
	  return;
	}
      }
    }
  }
}


void DaisyChain::removeAllLocks(void* from) {
  int i;

  for(i=0;i<_MAX_LOCKS;i++) {
    if (lockTupel[i]->valid==true) {
      if (lockTupel[i]->from==from) {
	  lockTupel[i]->valid=false;
	  decLock((lockTupel[i]->to));
      }
    }  
  }
}



void DaisyChain::incLock(StreamProducer* producer) {
  int i;
  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==true) {
      if (daisyChain[i]->element == producer) {
	daisyChain[i]->locks++;
      }
    }  
  }
}


void DaisyChain::decLock(StreamProducer* producer) {
  int i;
  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==true) {
      if (daisyChain[i]->element == producer) {
	daisyChain[i]->locks--;
	if (daisyChain[i]->locks == 0) {
	  if (lProducerAlreadyLocked == false) {
	    producer->writeInLock();
	    producer->writeInUnlock();
	  }
	}	    
      }
    }  
  }
}


int DaisyChain::hasLock(StreamProducer* producer) {
  int i;
  for(i=0;i<_MAX_DAISYCHAIN_ELEMENTS;i++) {
    if (daisyChain[i]->valid==true) {
      if (daisyChain[i]->element == producer) {
	return daisyChain[i]->locks;
      }
    }  
  } 
  debugOutput( cout << "fatal error DaisyChain::hasLock"<<endl);
  exit(0);
}
 
