/*
  sends the yafControl messages to the conneted listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <producer/yaf/yafMulticaster.h>
#include "../../../../config.h"



YafMulticaster::YafMulticaster() {
  int i;

  for(i=0;i<_MAX_LISTENERS;i++) {
    listenerArray[i]=new ListenerEntry();
    listenerArray[i]->valid=false;
    listenerArray[i]->listener=NULL;
  }
}


YafMulticaster::~YafMulticaster() {
  int i;

  for(i=0;i<_MAX_LISTENERS;i++) {
    delete listenerArray[i];
  }  
}


void YafMulticaster::multicastRuntimeCommand(int command,char* args) {
  int i;

  for(i=0;i<_MAX_LISTENERS;i++) {
    if (listenerArray[i]->valid == true) {
      ControlChannel* listener=listenerArray[i]->listener;
      if (listener == NULL) {
	debugOutput( cout << "error in YafMulticaster:NULL"<<endl );
	exit(0);
      }
      listener->processRuntimeCommand(command,args);
    } 
  }   
}


void YafMulticaster::multicastReturnCommand(int cmdNr,int cmdId,
					    char* ret,char* args) {
  int i;

  for(i=0;i<_MAX_LISTENERS;i++) {
    if (listenerArray[i]->valid == true) {
      ControlChannel* listener=listenerArray[i]->listener;
      if (listener == NULL) {
	debugOutput( cout << "error in YafMulticaster:NULL"<<endl );
	exit(0);
      }
      listener->processReturnCommand(cmdNr,cmdId,ret,args);
    }  
  }
}


void YafMulticaster::addYafListener(ControlChannel* listener) {
  int i;

  for(i=0;i<_MAX_LISTENERS;i++) {
    if (listenerArray[i]->valid == false) {
      (listenerArray[i]->listener)=listener;
      listenerArray[i]->valid=true;
      return;
    }  
  }  
  debugOutput( cout << "Too much YafListeners - add ignored"<<endl );
}


void YafMulticaster::removeYafListener(ControlChannel* listener) {
  int i;
   
  for(i=0;i<_MAX_LISTENERS;i++) {
    if (listenerArray[i]->valid == true) {
      (listenerArray[i]->listener)=listener;
      listenerArray[i]->valid=false;
      return;
    }  
  }  
  debugOutput( cout << "removeYafListener not found"<<endl ); 
}
