/*
  writes stream into a file. And takes care of a few things
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


extern "C" {
#include <yafcore/streamWriter.h>
	   }

#include <yafcore/yafRuntime.defs>

#include <yafcore/runtimeTableYAF.h>
#include <yafcore/commandTable.h>
#include <yafcore/outputInterface.h>

#include <audio/audioWrapper.h>

#define __BUFFER_SIZE 1024*64

extern "C++" {
#include <yafxplayer/inputDecoderXPlayer.h>
#include <yafxplayer/commandTableXPlayer.h>
#include <yafxplayer/runtimeTableXPlayer.h>
	     }

#include "../../../../config.h"

static int sd;
static struct sockaddr_un sockad;
static int lOpen;

static char* _filename;
static int _nBytesWrite;
static CommandTable* _runtimeTable;
static int _blockedArea; 
static long bytes;
static long allWrite;
static OutputInterface* output;

static AudioWrapper* audioWrapper=NULL;
static lInternalDevice;

void StreamWriter_sendSpeed(int speed);
void StreamWriter_sendSampleSize(int size);
void StreamWriter_sendChannels(int channels);


extern "C" void StreamWriter_writeMessage(char* msg) {
  output->lock();
  output->setNr(0);
  output->appendBuffer(msg);
  output->flushBuffer();
  output->unlock();
}


extern "C" void StreamWriter_Construct(void* out) {

  lOpen=false;
  _filename=NULL;
  _nBytesWrite=0;
  output=(OutputInterface*)out;
  _runtimeTable=new CommandTable();
  _runtimeTable->join(new RuntimeTableXPlayer());
  _blockedArea=false;

  audioWrapper=new AudioWrapper();
  lInternalDevice=false;

  bytes=0;
  allWrite=0;
}



extern "C" void StreamWriter_Destruct() {
  delete audioWrapper;
}


void StreamWriter_setBytesCounter(long aValue) {
  bytes=aValue;
}


long StreamWriter_getBytesCounter() {
  return bytes;
}

  

void StreamWriter_setStreamFile(char* filename) {
  if (lOpen == true) {
    StreamWriter_closeStream();
  }
  _filename=filename;
}


extern "C" int StreamWriter_openStream() {
  if (lOpen == true) {
    debugOutput( cout << "stream already open! call ignored"<<endl );
    return sd;
  }
  sd=::socket(AF_UNIX,SOCK_STREAM,0);
  if (sd < 0) {
    perror("sd-Socket StreamWriter");exit(1);
  }
  
  unsigned int i=0;
  sockad.sun_family=AF_UNIX;

  while(i<strlen(_filename)) {
        sockad.sun_path[i]=_filename[i];
        i++;
  }
  sockad.sun_path[i]=0;
  if (::connect(sd,(sockaddr*)&sockad,strlen(_filename)+2)<0) {
    perror("connect StreamWriter");exit(1);
  }
  if (sd > 0) {
    lOpen=true;
  }
  return sd;
}

extern "C" int StreamWriter_isOpenStream() {
  return lOpen;
}


extern "C" int StreamWriter_closeStream() {
  int ret=0;
  if (lOpen) {
    ret=close(sd);
    lOpen=false;
    _filename=NULL;
    StreamWriter_resetStream();
  } else {
    debugOutput( cout << "stream already closed. call ignored!"<<endl );
  }
  return ret;
}


extern "C" int StreamWriter_isBlocked() {
  return _blockedArea;
}



extern "C" int StreamWriter_writeStream(char* buf, int len) {
  int ret=0;
  if (lInternalDevice) {
    if (audioWrapper->isOpen() == false) {
      audioWrapper->open();
    }
    audioWrapper->write(buf,len);
  }

  if (lOpen) {
    ret=::send(sd,buf,len,0);

    
    if (ret < 0) {
      
      StreamWriter_closeStream();
      StreamWriter_writeMessage("fifo error in streamWriter");
      perror("writeStream");
      exit(-1);
      return ret;
    }

    bytes=bytes+len;
    allWrite+=len;
    return len;
  }
  bytes=bytes+len;
  allWrite+=len;
  return sd;
}


extern "C" void StreamWriter_resetStream() {
  _nBytesWrite=0;
}



extern "C" int StreamWriter_getBytesWrite() {
  return _nBytesWrite;
}

extern "C" long StreamWriter_getAllWriteCounter() {
  return allWrite;
}


extern "C" void StreamWriter_sendStreamInfo(int channels, 
					    int sampleSize,
					    int speed) {

  cout << "Command:0 Msg:streamInfo-Start"<<endl;
  cout << "Command:0 Msg:streamInfo-Channels "<<channels<<endl;
  cout << "Command:0 Msg:streamInfo-SampleSize "<<sampleSize<<endl;
  cout << "Command:0 Msg:streamInfo-Speed "<<speed<<endl;
  cout << "Command:0 Msg:streamInfo-End"<<endl;

  if (lInternalDevice) {
    audioWrapper->init(sampleSize,speed,channels-1);
  }


}




extern "C" void StreamWriter_internalDevice(int on) {

  lInternalDevice=on;
  
  if (lInternalDevice) {
    if (audioWrapper->isOpen() == false) {
      audioWrapper->open();
    }
  } else {
    if (audioWrapper->isOpen() == true) {
      audioWrapper->close();
    }
  }
}


