/*
 *	      LCDWidget - LCD display widget for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef LCDWidget_included
#define LCDWidget_included

#include <qlcdnum.h>
#include <qwidget.h>
#include <qframe.h>
#include <iostream.h>
#include "bwlednum.h"

#define LCD_MAX_LEN 10
class LCDWidget : public QFrame
{
	Q_OBJECT
	
	BW_LED_Number *led_array[LCD_MAX_LEN];
	int X, Y, W, H;
	int lenght;
	QColor backg, foreg, offg;
	
	public:
	LCDWidget ( QWidget *parent=0, const char *name=0 );
	~LCDWidget ();
	virtual void setGeometry (int=0, int=0, int=40, int=20);
	virtual void display (const int);
	virtual void display (const char *);
	virtual bool setNumDigits (const int);
	virtual void setSmallLEDS (const bool);
	virtual void setColors (QColor, QColor, QColor);
};

#endif // LCDWidget_included
