/***************************************************************************
                          kmp3db.cpp  -  description                              
                             -------------------                                         
    begin                : Thu May 27 1999                                           
    copyright            : (C) 1999 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include <qmessagebox.h>
#include <qlistview.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qregexp.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kprocess.h>

#include "general.h"
#include "kmp3db.h"
#include "confdlg.h"
#include "adddlg.h"
#include "dbhandling.h"
#include "mp3listview.h"
#include "mpqlistviewitem.h"
#include "scqlineedit.h"

extern QString cdrompath;
extern QString mp3dbpath;
extern QString mp3player;

KApplication *mykapp;

TopLevel::TopLevel (QWidget *parent, const char *name)
			: KTMainWindow(name) {
//    : KTopLevelWidget ( name) {

 int y=35;
 QRect r;

 resize(480, 300);
 setupMenuBar();
 read_settings();

 dbhandling = new DBhandling(); // for making a list

 outerframe = new QGroupBox(this,"box");
 outerframe->setGeometry(5,y,350,165);

 y+=10;
 r.setRect(15,y,130,25);
 chkboxfilename = new QCheckBox("Filename", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxfilename->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 filnamecmd = new QLineEdit(this,"filenamepath");
 filnamecmd->setGeometry(r);
 connect(filnamecmd, SIGNAL(returnPressed()), SLOT(search()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxfilename_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxfilename_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxArtist = new QCheckBox("Artist", this);
 //chkboxArtist->setChecked(TRUE);
 chkboxArtist->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 artistcmd = new QLineEdit(this,"artistpath");
 artistcmd->setGeometry(r);
 connect(artistcmd, SIGNAL(returnPressed()), SLOT(search()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxArtist_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxArtist_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxTitle = new QCheckBox("Title", this);
 //chkboxTitle->setChecked(TRUE);
 chkboxTitle->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 titlecmd = new QLineEdit(this,"titlepath");
 titlecmd->setGeometry(r);
 connect(titlecmd, SIGNAL(returnPressed()), SLOT(search()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxTitle_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxTitle_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxAlbum = new QCheckBox("Album", this);
 //chkboxAlbum->setChecked(TRUE);
 chkboxAlbum->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 albumcmd = new QLineEdit(this,"albumpath");
 albumcmd->setGeometry(r);
 connect(albumcmd, SIGNAL(returnPressed()), SLOT(search()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxAlbum_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxAlbum_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxCD = new QCheckBox("CD", this);
 //chkboxAlbum->setChecked(TRUE);
 chkboxCD->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 CDcombo = new QComboBox(FALSE, this,"cds");
// QList<CDList> *cdList = new QList<CDList>();

 cdlist = new QList<CDList>();
 fillCDDropDown();
 CDcombo->setGeometry(r);

 QPushButton *ok = new QPushButton(this, "searchbutton");
 ok->setText("Search!");
 //ok->setFocus();
 r.setRect(380,50,80,25);
 ok->setGeometry(r);
 connect(ok, SIGNAL(clicked()), SLOT(search()));

 ok->setAutoDefault(true);
 if (ok->isDefault()== TRUE)
  printf("isDefault==true !\n");
 else printf("isDefault==false!\n");

 y+=85;
 mp3list = new QListView(this);
 //r.setRect(0,y,350,100);        This is no use. resizeEvent() is called
 //mp3list->setGeometry(r);
 mp3list->addColumn("Artist");
 mp3list->setColumnWidth(ARTIST_COL, 120);

 mp3list->addColumn("Title");
 mp3list->setColumnWidth(TITLE_COL, 120);

 mp3list->addColumn("Album");
 mp3list->setColumnWidth(ALBUM_COL, 120);

 mp3list->addColumn("Year");
 mp3list->setColumnWidth(YEAR_COL, 40);

 mp3list->addColumn("Filename", 2);
 //mp3list->setColumnWidth(4, 2);
 mp3list->setColumnWidthMode (4, QListView::Manual);

 mp3list->addColumn("CD/HD");
 mp3list->setColumnWidth(5, 0);
 mp3list->setGeometry(r);
 //mp3list->setMultiSelection(TRUE);
 mp3list->setAllColumnsShowFocus(TRUE);
 connect(mp3list, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(play_mp3(QListViewItem *)));
 connect(mp3list, SIGNAL(rightButtonClicked(QListViewItem*, const QPoint &, int)),
         this, SLOT(show_menu(QListViewItem*, const QPoint &, int)));
 connect(mp3list,SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(update_statusbar(QListViewItem *)));
 connect(mp3list, SIGNAL(returnPressed(QListViewItem*)), SLOT(play_mp3(QListViewItem *)));
// connect(mp3list, SIGNAL(selectionChanged ()), mp3list, SLOT(setFocus ()));

 popup_menu = new KPopupMenu();
 popup_menu->insertItem (i18n("play"), this, SLOT(play_from_menu()));
 popup_menu->insertItem (i18n("add to playlist"), this, SLOT(add_to_playlist_from_menu()));
 popup_menu->insertSeparator(-1);
 popup_menu->insertItem (i18n("delete"), this, SLOT(delete_from_menu()));

 statusbar = new KStatusBar( this );
 char Found[50];
 sprintf(Found, "Found : %-7s", "0");  // 7 digits must be enough
 statusbar->insertItem(Found, 0);
 statusbar->insertItem("File : ", 1);
 setStatusBar( statusbar );

}

TopLevel::~TopLevel(void) {
}

void TopLevel::update_statusbar(QListViewItem *item) {

 char text[255];
 sprintf(text, "File : %-7s", item->text(4));
 statusbar->changeItem(text, 1);
}

//
// fillCDDropDown
//
void TopLevel::fillCDDropDown(void) {
 cdlist->clear();
 CDcombo->clear();
 buildCDList();

 CDList *cdentry;
 for (cdentry = cdlist->first(); cdentry != 0; cdentry=cdlist->next())
  CDcombo->insertItem(cdentry->CDname);
 CDcombo->insertItem("HD"); // also add HD to the list

}

// Build a list of CDs
//void TopLevel::buildCDList(QList<CDList> *list) {
void TopLevel::buildCDList(void) {
 FILE *fileptr;
 char filename[MAXFILELEN+1];
 char line[MAXLINELEN+1];
 char cdname[100+1];
 int i;
 CDList *cdentry;

 memset(cdname, 0, 101);
 sprintf(filename, "%s", (const char*)mp3dbpath);
 if ((fileptr=fopen(filename, "r")) ==NULL) {
   printf("unable to open %s\n", (const char*)mp3dbpath);
   QString tmpmsg = "unable to open file : ";
   tmpmsg += filename;
   QMessageBox::warning(this, "Error", tmpmsg);
   return;
 }

 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
   if (line[0] == '<' ) { // cd name is found
   //printf("buildCDList : line=%s\n", line);
     i=1;
     while (line[i] != SEPARATOR) {
       cdname[i-1] = line[i];
       i++;
     }
     cdname[i-2]=0; // deleting the ending '>'
     if (strlen(cdname)==0) strcpy(cdname, "- No description -");

     cdentry = new CDList(cdname);
     CDList  *tmpcd;
     int cdfound=0;
     for (tmpcd = cdlist->first(); tmpcd !=0; tmpcd = cdlist->next())
       if (strcmp(tmpcd->CDname, cdname) == 0) {
         //printf("buildCDList() : appending cd to list, cd=%s\n", cdname);
         cdfound=1;
       }
     if (!cdfound) cdlist->append(cdentry);
   }
 }
 fclose(fileptr);
}


void TopLevel::play_from_menu(void) {

 emit play_mp3( mp3list->currentItem());
}

void TopLevel::add_to_playlist_from_menu(void) {

 emit add_mp3_to_playlist( mp3list->currentItem());
}

void TopLevel::delete_from_menu(void) {

 //QMessageBox *pop;
 //pop->information( this, "Delete",
 //                  "Not implemented yet");
 QListViewItem *mp3listitem = new QListViewItem(mp3list);
 mp3listitem = mp3list->currentItem();

 unsigned int itempos = mp3list->itemPos(mp3listitem);
 printf("item position = %d\n", itempos);

 DBentry *entry = new DBentry("HD");
 entry->artist.setStr( mp3listitem->text(ARTIST_COL));
 entry->title.setStr( mp3listitem->text(TITLE_COL));
 entry->album.setStr( mp3listitem->text(ALBUM_COL));
 strcpy(entry->year, mp3listitem->text(YEAR_COL));
 entry->filename.setStr(mp3listitem->text(FN_COL));
 strcpy(entry->where, mp3listitem->text(HDCD_COL));
 //entry = dbhandling->dbentrieslist->at(mp3list->childCount()-itempos);
 //printf("itempos=%d, mp3listitem->artist=%s, mp3listitem->title=%s\n", itempos, mp3listitem->text(ARTIST_COL), mp3listitem->text(TITLE_COL));
 //printf("entry->artist=%s, entry->title=%s\n", entry->artist, entry->title);
 // be sure to have the right entry
 //if (strcmp(mp3listitem->text(ARTIST_COL), entry->artist) !=0 ||
 //    strcmp(mp3listitem->text(TITLE_COL), entry->title) !=0) {
 //  printf(" WE HAVE A SYNCHRONISATION PROBLEM HERE (between listview and dblist)\n");
 //  return;
 //}

 dbhandling->deleteFromDB(entry);

 //mp3list->remove(mp3list->currentItem());
 search(); // update the view

}

void TopLevel::show_menu(QListViewItem *item, const QPoint &pos, int i) {

 QString titletext;
 titletext = item->text(0);
 titletext += " - ";
 titletext += item->text(1);
// item = mp3list->currentItem();
 popup_menu->setTitle(titletext);
 mp3list->setSelected(item, TRUE);  // select where the mouse is, otherwise it could be not selected
// mp3list->setCurrentItem(item);
 popup_menu->popup(pos, 0);
 //popup_menu->show();
}

void TopLevel::setupMenuBar(void){

 file = new QPopupMenu ();
 commands = new QPopupMenu ();
 configmenu = new QPopupMenu();
 help = new QPopupMenu ();

 file->insertItem (i18n("Close"), this  , SLOT(close()));

 commands->insertItem("Play", this  , SLOT(menu_play_mp3()));
 commands->insertItem("Add to playlist", this  , SLOT(menu_add_mp3_to_playlist()));
 commands->insertItem("Delete", this  , SLOT(delete_from_menu())); // somewhat weird names sometimes...

 configmenu->insertItem("Add mp3...", this, SLOT(add_mp3()) );
 configmenu->insertItem("Configure...", this, SLOT(configure()) );
 configmenu->insertItem("Save Settings", this, SLOT(save_settings()) );

 help->insertItem("About kmp3db...", this, SLOT(about()));
 help->insertItem("Contents", this, SLOT(contents()));

 menubar = new KMenuBar (this, "menubar");
 menubar->insertItem(i18n("&File"), file);
 menubar->insertItem(i18n("&Commands"), commands);
 menubar->insertItem(i18n("&Config"), configmenu);
 menubar->insertItem(i18n("&Help"), help);

}

// Search in the database and put all in a list
void TopLevel::search(void) {

 int aantal=0;
 char tmpstr[50];
 DBentry *dbentry;

 mp3list->clear(); // clear the list
 dbhandling->clearList();
 statusbar->changeItem("Found : 0", 0);
 statusbar->changeItem("File :", 1);

 if (chkboxfilename->isChecked()) {
  printf("TopLevel::search : searching for filename\n");
  dbhandling->find((char*)filnamecmd->text(), chkboxfilename_cs->isChecked(), Filename);
 }

 if (chkboxArtist->isChecked()) {
  printf("searching for artist\n");
  dbhandling->find((char*)artistcmd->text(), chkboxArtist_cs->isChecked(), Artist);
 }

 if (chkboxTitle->isChecked()) {
  printf("searching for artist\n");
  dbhandling->find((char*)titlecmd->text(), chkboxTitle_cs->isChecked(), Title);
 }

 if (chkboxAlbum->isChecked()) {
  printf("searching for album\n");
  dbhandling->find((char*)albumcmd->text(), chkboxAlbum_cs->isChecked(), Album);
 }

 if (chkboxCD->isChecked()) {
  printf("searching for CD\n");
  dbhandling->find((char*)CDcombo->currentText(), true, cdname);
 }

 for (dbentry=dbhandling->dbentrieslist->first();
      dbentry != 0; dbentry=dbhandling->dbentrieslist->next() ) {
  //printf("adding number %d to mp3list\n", i++);
  MPQListViewItem *item = new MPQListViewItem(mp3list);
  item->setText(0,(const char*)dbentry->artist);
  item->setText(1, (const char*)dbentry->title);
  item->setText(2, (const char*)dbentry->album);
  item->setText(3, dbentry->year);
  item->setText(4, (const char*)dbentry->filename);
  item->setText(5, dbentry->where);
  aantal++;
  //printf("aantal=%d\n", aantal);
  sprintf(tmpstr, "Found : %d", aantal);
  statusbar->changeItem(tmpstr, 0);
  mp3list->setCurrentItem(item);
  //mp3list->setColumnWidth(4, 2);
  //mp3list->setColumnWidthMode (4, QListView::Manual);
 }
 switch (mp3list->columnWidthMode(4)) {
  case QListView::Manual : printf("col4 is Manual\n");break;
  case QListView::Maximum : printf("col4 is Maximum\n");break;
 }


}

void TopLevel::read_settings(void) {
 QString str;

 cdrompath = "/cdrom";
 mp3dbpath = getenv("HOME");
 mp3dbpath += "/mp3.db";
 mp3player = "kmp3";

 config = mykapp->getConfig();
 config->setGroup( "Player Settings" );

 str = config->readEntry("cdrom path");
 if ( !str.isNull() )
    cdrompath=str.data();
    //strcpy(cdrompath, str.data());

 str = config->readEntry("Database");
 if ( !str.isNull() )
     mp3dbpath=str.data();
    //strcpy(mp3dbpath, str.data());

 str = config->readEntry("mp3player");
 if ( !str.isNull() )
    mp3player=str.data();
    //strcpy(mp3player, str.data());
}

void TopLevel::save_settings(void) {
  config = mykapp->getConfig();
  config->setGroup( "Player Settings" );

  QString value;
  value = cdrompath;
  config->writeEntry("cdrom path", value);

  value = mp3dbpath;
  config->writeEntry("Database", value);

  value = mp3player;
  config->writeEntry("mp3player", value);

  config->sync();
}

void TopLevel::menu_play_mp3(void) {
 QListViewItem *item = mp3list->currentItem ();
 emit play_mp3(item);
}
void TopLevel::play_mp3(QListViewItem *item) {
  KProcess process;
  QString cdname;
  QString arg;
  //QListViewItem *item = mp3list->currentItem ();
  printf("in play_mp3()\n");
  //printf("text=%s\n", item->text(4)); // item is the row, text(num) is column

  if (strcmp(item->text(5), "HD") != 0) { // if item is not on HD
   arg += cdrompath;
   arg += "/";
  }
  arg+= item->text(4);

  process << mp3player << arg;
  process.start(KProcess::DontCare);

}

void TopLevel::menu_add_mp3_to_playlist(void) {
 QListViewItem *item = mp3list->currentItem ();
 emit add_mp3_to_playlist(item);
}
void TopLevel::add_mp3_to_playlist(QListViewItem *item) {
  KProcess process;
  QString cdname;
  QString arg;
  //QListViewItem *item = mp3list->currentItem ();
  printf("in add_mp3()\n");
  //printf("text=%s\n", item->text(4)); // item is the row, text(num) is column

  if (mp3player=="xmms") {
   //arg = "-e ";
   if (strcmp(item->text(5), "HD") != 0) { // if item is not on HD
    arg += cdrompath;
    arg += "/";
   }
   arg+= item->text(4);
   //printf("player=%s, arg = %s\n", (char*)mp3player, (char*)arg);
   process << mp3player << "-e" << arg;
   process.start(KProcess::DontCare);
  }
  else {
   QMessageBox *pop;
   pop->information( this, "Error",
                   "Not supported by this mp3 player");
  }

}


void TopLevel::close()
{
 printf("close\n");
 mykapp->quit();
}

// dialog for setting configuration items
void TopLevel::configure(void) {

 printf("configure\n");
 ConfDlg *dlg;

 dlg = new ConfDlg(this, "confdialog");
 dlg->setCaption(i18n("Configure"));

 if (dlg->exec() == QDialog::Accepted) {
  printf("dlg->exec accepted\n");
  fillCDDropDown();// reread all CD dropdown entries


 }
 delete dlg;

}

void TopLevel::about(void) {

  char about_str[200];
  QMessageBox *pop;

  sprintf(about_str, "kmp3db Version %s\n\nAuthor : Edwin Schepers \ne-mail : zeus@castel.nl",
          KMP3DB_VERSION);
  pop->information( this, "About kmp3db", about_str);
}

void TopLevel::contents(void) {

 printf("contents\n");
 QMessageBox *pop;
  pop->information( this, "Contents",
                   "Not implemented yet");

}

// dialog for adding mp3's to the database
void TopLevel::add_mp3(void) {
 AddDlg *dlg;

 dlg = new AddDlg(this, "confdialog");
 dlg->setCaption(i18n("Add mp3"));

 if (dlg->exec() == QDialog::Accepted) {
  printf("dlg->exec accepted\n");
  if (!dlg->CDName.isEmpty())
    CDcombo->insertItem((const char*)dlg->CDName);
 }
 delete dlg;
 //search(); // Where is this new mp3 all the time ? :)
}

bool TopLevel::eventFilter(QObject *o, QEvent *ev) {

 printf("in the eventFilter...\n");

 QMouseEvent *e = (QMouseEvent *)ev;
 if(e->button() == RightButton)
  printf("TopLevel : right mousebutton pressed\n");

 return TRUE;
}

void TopLevel::resizeEvent(QResizeEvent *re) {

  //QSize *size;
  QRect r;
  //printf("TopLevel::resizeEvent\n");

  //size = re->size();
  //printf("width=%d, height=%d\n", width(), height());
  r.setRect(5,205,width()-10,height()-225); // it's terrible to work with all those numbers...but ok it's only my first program.
  //r.setWidth(width()-10);
  mp3list->setGeometry(r);

  setStatusBar( statusbar );

}
/******************************
 *
 * The main...
 *
*******************************/
int main (int argc, char **argv)
{
 mykapp = new KApplication (argc, argv, "kmp3db");

 TopLevel *t = new TopLevel ();
 t->show ();
//  TopLevel::windowList.append( t );
 return mykapp->exec ();
 printf("einde programma\n");
}
























































































































































































































































