/*
  Configuration Dialog for ipcModule
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <ipcConfig.h>



IPCConfig::IPCConfig(const char* configGroup,
		     Playlist* playlist,
		     QWidget * parent=0, const char * name=0 )
                     : PrefConfig(parent,name) {
  this->configGroup=configGroup;
  config = kapp->getConfig();
  configGroup="IPC";
  this->playlist=playlist;
  load();

  QVBoxLayout* vLayout=new QVBoxLayout(this,20);

  QButtonGroup *bg = new QButtonGroup(i18n("playlist received"), this );
  QVBoxLayout *vbox = new QVBoxLayout(bg, 5);
  vbox->addSpacing( bg->fontMetrics().height() );
  QRadioButton* rb1 = new QRadioButton(i18n("direct play"),bg);
  bg->insert(rb1,_IPC_NOARGUMENT_PLAY);
  rb1->setMinimumSize( rb1->sizeHint() );

  QRadioButton* rb2 = new QRadioButton(i18n("insert last"),bg);
  rb2->setMinimumSize( rb2->sizeHint() );
  bg->insert(rb2,_IPC_NOARGUMENT_APPEND);
 

  QRadioButton* rb3 = new QRadioButton(i18n("ignore"),bg);
  rb3->setMinimumSize( rb3->sizeHint() );
  bg->insert(rb3,_IPC_NOARGUMENT_IGNORE);
  

  vbox->addWidget(rb1);
  vbox->addWidget(rb2);
  vbox->addWidget(rb3);

  bg->setButton(mode);
  setNoArgMode(mode);
  bg->setGeometry(20, 40, 300, 120 );

  QLabel* lineLable = new QLabel(this);
  lineLable->setText(
           i18n("This defines the behaviour of new instances of kmpg."));
  lineLable->setMinimumSize(lineLable->sizeHint());
  lineLable->setMaximumSize(lineLable->sizeHint());


  QPushButton* button=new QPushButton(i18n("Get IPC handle"),this);
  button->setMinimumSize(QSize(200,30));
  button->setMaximumSize(QSize(200,30));
  connect(button,SIGNAL(pressed()),SLOT(grapIPCHandle()));

  QLabel* lineLable1 = new QLabel(this);
  lineLable1->setText(
           i18n("If you want to start kmpg as a seperate process"));
  lineLable1->setMinimumSize(lineLable1->sizeHint());
  lineLable1->setMaximumSize(lineLable1->sizeHint());
  

  QLabel* lineLable2 = new QLabel(this);
  lineLable2->setText(
           i18n("you must close the IPC handle."));
  lineLable2->setMinimumSize(lineLable2->sizeHint());
  lineLable2->setMaximumSize(lineLable2->sizeHint());
  

  QPushButton* button1=new QPushButton(i18n("Close IPC forever"),this);
  button1->setMinimumSize(QSize(200,30));
  button1->setMaximumSize(QSize(200,30));
  
  connect(button1,SIGNAL(pressed()),SIGNAL(closeIPCHandleForever()));

  connect(bg,SIGNAL(pressed (int)),SLOT(setNoArgMode(int)));
  vLayout->addStretch();
  vLayout->addWidget(bg,0,AlignLeft);
  vLayout->addStretch();

  vLayout->addWidget(lineLable,0,AlignLeft);
  vLayout->addWidget(button,0,AlignLeft);
  vLayout->addStretch();

  vLayout->addWidget(lineLable1,0,AlignLeft);
  vLayout->addWidget(lineLable2,0,AlignLeft);
  vLayout->addWidget(button1,0,AlignLeft);
  vLayout->addStretch();
 
 
}


IPCConfig::~IPCConfig() {
}


const char* IPCConfig::getGroupName() {
  return "IPC";
}


void IPCConfig::load() {
  config->setGroup(configGroup);
  mode=config->readNumEntry( "noArgumentMode", _IPC_NOARGUMENT_PLAY);
 
}


void IPCConfig::save() {
  config->setGroup(configGroup);
  config->writeEntry("noArgumentMode",mode);
}


void IPCConfig::apply() {
  save();
}


void IPCConfig::setNoArgMode(int mode) {
  this->mode=mode;
  KmpgCommandLine::setArgMode(mode);
}



void IPCConfig::grapIPCHandle() {
  KmpgCommandLine::setPlaylist(playlist);
}
