/*
  a view for a playlist.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <playlistView1.h>





class EmptyAndAlwaysLastItem : public QListBoxItem {
   public:
      EmptyAndAlwaysLastItem(){};
      ~EmptyAndAlwaysLastItem(){};

   protected:
      void paint( QPainter* ){};
      int height( const QListBox* ) const { return 80; };
      int width( const QListBox* ) const { return 50; };
};











PlaylistView1::PlaylistView1( Playlist* playlist,
			  QWidget * parent=0, const char * name=0, WFlags f=0 )
  : QListBox( parent, name, f ) {
  
  this->playlist=playlist;
  preferences=new Preferences();
  playlistView1Config=new PlaylistView1Config(preferences);
  preferences->setCaption(playlistView1Config->getGroupName());
  preferences->addTab(playlistView1Config,playlistView1Config->getGroupName());

  infoDeviceConfig=new InfoDeviceConfig("PlaylistInfo",preferences);
  preferences->addTab(infoDeviceConfig,infoDeviceConfig->getGroupName());
  
  menuDescription=new MenuDescription(i18n("Playlist"));
  menuDescription->insertMenu(i18n("Configure"),preferences,SLOT(show()));

  dropZone = new KDNDDropZone( this, DndURL );
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone* )),
	    SLOT( slotDrop( KDNDDropZone*)));

  connect(playlist,SIGNAL(addSongEvent(Song*,int)),
	   this,SLOT(addSongEvent(Song* ,int )));
  connect(playlist,SIGNAL(songUpdateEvent(Song*,int)),
	   this,SLOT(songUpdateEvent(Song* ,int )));
  connect(playlist,SIGNAL(removeSongEvent(int)),
	   this,SLOT(removeSongEvent(int ) ));
  connect(playlist,SIGNAL(swapSongEvent(int ,int )),
	   this,SLOT(swapSongEvent(int ,int )));
  connect(playlist,SIGNAL(clearEvent()),
	  this,SLOT(clearEvent()));			   
  connect(playlist,SIGNAL(setCurrentPosEvent(int)),
	  this,SLOT(setCurrentPosEvent(int)));			   
  connect(this,SIGNAL(selected(int)),this,SLOT(selected(int)));
  connect(this,SIGNAL(highlighted(int)),this,SLOT(highlighted(int)));

  insertItem(new EmptyAndAlwaysLastItem(),0);

}


PlaylistView1::~PlaylistView1() {
  delete menuDescription;
}

void PlaylistView1::songUpdateEvent(Song* song,int index) {
  SongView1* songView1=(SongView1*)item(index);
  songView1->doUpdate();
  repaint(true);
}



void PlaylistView1::addSongEvent(Song* song,int index) {
  SongView1* songView1=new SongView1(song,infoDeviceConfig);
  insertItem(songView1,index);
}


void PlaylistView1::removeSongEvent(int index) {
  removeItem(index);
}

void PlaylistView1::clearEvent() {
  clear();
  insertItem(new EmptyAndAlwaysLastItem(),0);
}

/**
   A bit work is needed to hide the EmptyAndAlwaysLastItem.
*/
void PlaylistView1::swapSongEvent(int index1,int index2) {
  int lastPos=(int)count()-1;

  if ((index1 == lastPos) || (index2 == lastPos)) {
    return;
  }

  if (index1 > index2) {
    int tmp=index1;
    index1=index2;
    index2=tmp;
  }
  removeItem (index1);
  removeItem (index2-1);
  Song* song;
  song=playlist->at(index1);
  addSongEvent(song,index1);

  song=playlist->at(index2);
  addSongEvent(song,index2);
}



void PlaylistView1::setCurrentPosEvent(int index) {
  int lastPos=(int)count()-1;
  if (index >= lastPos) {
    return;
  }
  if (index == -1) {
    return;
  }
  setCurrentItem (index);
}
  


void PlaylistView1::selected (int index) {
  int lastPos=(int)count()-1;
  if (index == lastPos) {
    setCurrentPosEvent(playlist->getCurrentPos());
    return;
  }
  PlaylistOperation::playCurrent(playlist);
}


void PlaylistView1::highlighted(int index) {
  int lastPos=(int)QListBox::count()-1;
  if (index == lastPos) {
    setCurrentPosEvent(playlist->getCurrentPos());
    return;
  }
  playlist->setCurrentPos(index);
}


void PlaylistView1::slotDrop(KDNDDropZone* zone) {
  int dropMode=playlistView1Config->getDropMode();
  if (dropMode == _PLV1_AT_END) {
    PlaylistOperation::rootInsert(zone,playlist);
    return;
  }
  int y=zone->getMouseY();
  QPoint point = mapToGlobal(QPoint(0,0));
  int relYPos=y-point.y();
  int itemPos=findItem(relYPos);
  int lastPos=(int)QListBox::count()-1;
  if (itemPos == -1) {
    itemPos=lastPos;
  }
  PlaylistOperation::rootInsert(zone,playlist,itemPos);
}




void PlaylistView1::mousePressEvent (QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    KPopupMenu* popupMenu=menuDescription->createPopupMenu();
    popupMenu->move(mapToGlobal(QPoint(mouseEvent->x(),mouseEvent->y())));
    popupMenu->exec();
    delete popupMenu;
    return;
  }
  if (mouseEvent->button() ==  LeftButton) {
    int itemPos=findItem(mouseEvent->y());
    int lastPos=(int)QListBox::count()-1;
    
    if (itemPos == -1) {
      return;
    }
    if (count() == 1) {
      return;
    }
    if (itemPos >= lastPos) {
      return;
    }
    QListBox::mousePressEvent(mouseEvent);
  }
}

void PlaylistView1::mouseMoveEvent (QMouseEvent* mouseMoveEvent) {
  int y=mouseMoveEvent->y();
  int current=playlist->getCurrentPos();

  
  int itemPos=findItem(y);
  int lastPos=(int)QListBox::count()-2;
  if (itemPos > lastPos) {
    return;
  }
  if (itemPos == -1) {
    return;
  }
  
  if (current != itemPos) {
    setAutoUpdate( FALSE );
    playlist->swapSong(current,itemPos);
    playlist->setCurrentPos(itemPos);
    setAutoUpdate( TRUE );
    repaint();
  }

}



void PlaylistView1::mouseDoubleClickEvent ( QMouseEvent* mouseEvent ) {

  int itemPos=findItem(mouseEvent->y());
  int lastPos=(int)QListBox::count()-1;
  
  if (itemPos == -1) {
    return;
  }
  if (count() == 1) {
    return;
  }
  if (itemPos >= lastPos) {
    return;
  }
  QListBox::mouseDoubleClickEvent(mouseEvent);
}




void PlaylistView1::slotUp() {
  int currentPos = currentItem();
   
  if( currentPos < 1 )
    return;
  setAutoUpdate( FALSE );
  playlist->swapSong(currentPos,currentPos-1);
  playlist->setCurrentPos(currentPos-1);
  setAutoUpdate( TRUE );
  repaint();
}

void PlaylistView1::slotDown() {
  int currentPos = currentItem();
  
  if (count() <= 2) {
    return;
  }
  if( currentPos > count()-3 )
    return;
  setAutoUpdate( FALSE );
  playlist->swapSong(currentPos,currentPos+1);
  playlist->setCurrentPos(currentPos+1);
  setAutoUpdate( TRUE );
  repaint();
}


void PlaylistView1::slotDelMPEG() {
  int pos= currentItem();
  if (pos == count()-1) {
    return;
  }
  Song* song=playlist->at(pos);
  if (song != NULL) {
    playlist->removeSong(pos);
    delete song;
  }
}

void PlaylistView1::dragEnterEvent( QDragEnterEvent * ) {
  cout << "dragEnterEvent"<<endl;
}

void PlaylistView1::dragMoveEvent( QDragMoveEvent * ) {
  cout << "dragMoveEvent"<<endl;
}

void PlaylistView1::dragLeaveEvent( QDragLeaveEvent * ) {
  cout << "dragLeaveEvent"<<endl;
}

void PlaylistView1::dropEvent( QDropEvent * ) {
  cout <<"dropEvent"<<endl;
}
