/*
  a view for a playlist.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <playlistView2.h>

#define CAPTION(file) QString( i18n("Playlist Editor: ") )+file

PlaylistView2::PlaylistView2(Playlist* playlist,
			     QWidget* parent=0, const char* name=0):
  QDialog(parent,name) {

  buttonPanel = new QWidget( this );
  dropZone = new KDNDDropZone( buttonPanel, DndURL );
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone* )),
	    SLOT( slotDrop( KDNDDropZone*)));
  this->playlist=playlist;
  playlistView1 = new PlaylistView1( playlist,this, "Playlist");
  setCaption( CAPTION("<noname>") );
  
  QPushButton *pb1 = new QPushButton(i18n("Close"),buttonPanel);
  QPushButton *pb2 = new QPushButton( i18n("Add MPEG"), buttonPanel );
  QPushButton *pb3 = new QPushButton( i18n("Load playlist"), buttonPanel );
  QPushButton *pb4 = new QPushButton( i18n("Add playlist"), 
				      buttonPanel );
  QPushButton *pb5 = new QPushButton( i18n("Save playlist"), buttonPanel );
  QPushButton *pb6 = new QPushButton( "up", buttonPanel );
  QPushButton *pb7 = new QPushButton( "dn", buttonPanel );
  QPushButton *pb8 = new QPushButton( i18n("Del MPEG"), buttonPanel );
  QPushButton *pb9 = new QPushButton( i18n("Clear list"), buttonPanel );

  
  QPixmap pix;
  KIconLoader *loader = KApplication::getKApplication()->getIconLoader();
  pix = loader->loadIcon("up.xpm");
  pb6->setPixmap( pix );
  pix = loader->loadIcon("down.xpm");
  pb7->setPixmap( pix );

  // now calculate the biggets width
  QPushButton* pb[9]={pb1,pb2,pb3,pb4,pb5,pb6,pb7,pb8,pb9};
  int i;
  int maxWidth=0;
  int maxHeight=0;
  for (i=0;i<9;i++) {
    QSize size=pb[i]->sizeHint();
    if (size.width() > maxWidth) {
      maxWidth=size.width();
    }
    if (size.height() > maxHeight) {
      maxHeight=size.height();
    }
  }
  QVBoxLayout *vbox = new QVBoxLayout(buttonPanel, 0);
  vbox->addSpacing( buttonPanel->fontMetrics().height() );

  pb[0]->setFixedSize(QSize(maxWidth,maxHeight));
  vbox->addWidget(pb[0]);
  vbox->addSpacing( buttonPanel->fontMetrics().height() );
 
  pb[1]->setFixedSize(QSize(maxWidth,maxHeight));
  pb[2]->setFixedSize(QSize(maxWidth,maxHeight));
  vbox->addWidget(pb[1]);
  vbox->addWidget(pb[2]);
  vbox->addSpacing( 5 );


  pb[3]->setFixedSize(QSize(maxWidth,maxHeight));
  pb[4]->setFixedSize(QSize(maxWidth,maxHeight));
  vbox->addWidget(pb[3]);
  vbox->addWidget(pb[4]);
  vbox->addSpacing( 5 );


  pb[5]->setFixedSize(QSize(maxWidth,maxHeight/2));
  pb[6]->setFixedSize(QSize(maxWidth,maxHeight/2));
  vbox->addWidget(pb[5]);
  vbox->addWidget(pb[6]);
  vbox->addSpacing( 5 );

  pb[7]->setFixedSize(QSize(maxWidth,maxHeight));
  pb[8]->setFixedSize(QSize(maxWidth,maxHeight));
  vbox->addWidget(pb[7]);
  vbox->addWidget(pb[8]);
  vbox->addSpacing( 5 );




  QHBoxLayout *hbox = new QHBoxLayout(this, 5);

  hbox->addWidget(playlistView1,1000);
  hbox->addWidget(buttonPanel);

  resize(QSize(maxWidth*4,maxHeight));


  connect( pb1, SIGNAL(clicked()), SLOT(hideRequest()) );
  connect( pb2, SIGNAL(clicked()), SLOT(slotAddMPEG()) );
  connect( pb3, SIGNAL(clicked()), SLOT(slotLoadPlaylist()) );
  connect( pb4, SIGNAL(clicked()), SLOT(slotAddPlaylist()) );
  connect( pb5, SIGNAL(clicked()), SLOT(slotSavePlaylist()) );
  connect( pb6, SIGNAL(clicked()), SLOT(slotUp()) );
  connect( pb7, SIGNAL(clicked()), SLOT(slotDown()) );
  connect( pb8, SIGNAL(clicked()), SLOT(slotDelMPEG()) );
  connect( pb9, SIGNAL(clicked()), playlist, SLOT(clear()) );
  connect(playlist,SIGNAL(setNameEvent(char*)),this,SLOT(setNameEvent(char*)));
  
  KWM::setWmCommand( handle(), "" ); // Disable SM for this window
}

PlaylistView2::~PlaylistView2() {
}




void PlaylistView2::slotLoadPlaylist() {
  Playlist* newList;
  newList=PlaylistOperation::readPlaylist();
  if (newList != NULL) {
    playlist->clear();
    playlist->setName(newList->getName());
    PlaylistOperation::insert(newList,playlist);
  }
}

void PlaylistView2::slotSavePlaylist() {
  if (PlaylistOperation::writePlaylist(playlist)) {
  }
}


void PlaylistView2::slotAddPlaylist() {
  Playlist* newList;
  newList=PlaylistOperation::readPlaylist();
  if (newList != NULL) {
    playlist->setName(newList->getName());
    PlaylistOperation::insert(newList,playlist);
  }
}


void PlaylistView2::slotAddMPEG() {
  PlaylistOperation::loadSong(playlist);
}


void PlaylistView2::slotUp() {
  playlistView1->slotUp();
}


void PlaylistView2::slotDown() {
  playlistView1->slotDown();
}


void PlaylistView2::slotDelMPEG() {
  playlistView1->slotDelMPEG();
}

void PlaylistView2::slotDrop( KDNDDropZone* zone ) {
  PlaylistOperation::rootInsert(zone,playlist);
}


void PlaylistView2::setNameEvent(char* name) {
  setCaption( CAPTION(name) );
}


void PlaylistView2::hideRequest() {
  emit(hideRequestEvent());
}

