/*
  speed, stereo, samplesize setting widget
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "sssBox.h"



SSSBox::SSSBox(QWidget * parent=0, const char * name=0 ):QWidget(parent,name) {




  audioFrame = new QGroupBox( i18n("Audio override"), this );

  QVBoxLayout *vbox1 = new QVBoxLayout(audioFrame, 5);
  vbox1->addSpacing( audioFrame->fontMetrics().height() );

  QWidget* w=new QWidget(audioFrame);

  QGridLayout* grid1 = new QGridLayout(w, 3,3,15);
  grid1->addColSpacing(1,50);

  QWidget* w1=new QWidget(audioFrame);
  w1->setFixedSize(QSize(50,20));
  grid1->addWidget(w1,0,1);
 


  grid1->addColSpacing(2,100);

  
  
  sampleSpeedLabel = new QLabel(w);
  sampleSpeedLabel->setText(i18n("Samplespeed :"));
  sampleSpeedLabel->setFixedSize(sampleSpeedLabel->sizeHint());
  
  sampleSpeedCBox = new QComboBox( w );
  sampleSpeedCBox->insertItem( "22050" );
  sampleSpeedCBox->insertItem( "44100" );
  sampleSpeedCBox->setFixedSize(sampleSpeedCBox->sizeHint());

  grid1->addWidget(sampleSpeedLabel,0,0);
  grid1->addWidget(sampleSpeedCBox,0,2);

  
  sampleSizeLabel = new QLabel(w);
  sampleSizeLabel->setText(i18n("Samplesize :"));
  sampleSizeLabel->setFixedSize(sampleSizeLabel->sizeHint());
   
  sampleSizeCBox = new QComboBox( w );
  sampleSizeCBox->insertItem( "16" );
  sampleSizeCBox->insertItem( "8"  );
  sampleSizeCBox->setFixedSize(sampleSizeCBox->sizeHint());

  grid1->addWidget(sampleSizeLabel,1,0);
  grid1->addWidget(sampleSizeCBox,1,2);

  stereoLabel = new QLabel(w);
  stereoLabel->setText(i18n("Stereo :"));
  stereoLabel->setFixedSize(stereoLabel->sizeHint());
  
  stereoCBox = new QComboBox( w );
  stereoCBox->insertItem( i18n("true") );
  stereoCBox->insertItem( i18n("false")  );
  stereoCBox->setFixedSize(stereoCBox->sizeHint());

  grid1->addWidget(stereoLabel,2,0);
  grid1->addWidget(stereoCBox,2,2);

  infoLabel1 = new QLabel(audioFrame);
  infoLabel1->setText(i18n("Use this if the automatic initialisation"));
  infoLabel1->setFixedSize(infoLabel1->sizeHint());
 
  infoLabel2 = new QLabel(audioFrame);
  infoLabel2->setText(i18n("of the device over http fails."));
  infoLabel2->setFixedSize(infoLabel2->sizeHint());
   
  vbox1->addWidget(w,0,AlignLeft);
  vbox1->addWidget(infoLabel1,0,AlignLeft);
  vbox1->addWidget(infoLabel2,0,AlignLeft);
  
  



}


SSSBox::~SSSBox() {
}
  


int SSSBox::getSampleSize() {
  int back=0;
  const char* text=sampleSizeCBox->currentText();
  if (strcmp(text,"16")==0) {
    back=16;
  }
  if (strcmp(text,"8")==0) {
    back=8;
  }
  return back;
}


int SSSBox::getSampleFreq() {
  int back=0;
  const char* text=sampleSpeedCBox->currentText();
  if (strcmp(text,"44100")==0) {
    back=44100;
  }
  if (strcmp(text,"22050")==0) {
    back=22050;
  }
  return back;
}


int SSSBox::getStereo() {
  int back=true;
  const char* text=stereoCBox->currentText();
  if (strcmp(text,i18n("true"))==0) {
    back=true;
  }
  if (strcmp(text,i18n("false"))==0) {
    back=false;
  }
  return back;
}
 


void SSSBox::setEnabled (bool val) {
  audioFrame->setEnabled(val);
  sampleSpeedCBox->setEnabled(val);
  sampleSizeCBox->setEnabled(val);
  stereoCBox->setEnabled(val);

  sampleSpeedLabel->setEnabled(val);
  sampleSizeLabel->setEnabled(val);
  stereoLabel->setEnabled(val);
  infoLabel1->setEnabled(val);
  infoLabel2->setEnabled(val);
}
