/*
  show crashhandling
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <crashHandler.h>


CrashHandler::CrashHandler() {

  installEventFilter(this);
  genericPlayer=Amplifier::createPlayer(_MP3_DECODER);
  //genericPlayer=Amplifier::createPlayer(_MPEG_VIDEO_DECODER);
  audioDevice=new AudioDevice("/dev/dsp");
  audioDevice->open();

  genericPlayer->addListener(audioDevice);
  QPushButton* b=new QPushButton("Delete");
  connect(b,SIGNAL(clicked()),this,SLOT(userCrash()));
  b->show();
  // YOU MUST CONNECT TO GET THE GLOBAL EVENT !!!!!!!!!!

  connect(genericPlayer->getEventQueue(),
	  SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
}


CrashHandler::~CrashHandler() {
  delete genericPlayer;
  delete audioDevice;
}


void CrashHandler::open(char* filename) {
  file=filename;
  genericPlayer->open(filename);
}


void CrashHandler::processEvent(char eventId) {
  switch(eventId) {
  case _GS_SIGNAL_PLAYING_READY: {
    cout << "song ended normally"<<endl;
    break;
  }
  default:
    cout << "unknown msg: "<<eventId<<" in StandardGraph::processEvent"<<endl;
  }
}
 

bool CrashHandler::eventFilter(QObject* object,QEvent *e) {
  cout << "eventFilter"<<endl;
#if (QT_VERSION < 200) 
  if ( e->type() == Event_User)     // yaf global event
#else
  if ( e->type() == QEvent::User)     // yaf global event
#endif
    {
      YafGlobalEvent* yafEvent = (YafGlobalEvent*)e;
      cout << "__YAFGLOBALEVENT_ID got"<<endl;

      if (yafEvent->getMsg() == _GS_SIGNAL_GENERATOR_CRASHED) {
	cout << "got generator crash*******"<<endl;
	if (genericPlayer->isRunning()==true) {
	  cout << "false alarm"<<endl;
	  return FALSE;
	}
	userCrash();
	return TRUE;                        // eat event
      }
    }
  return FALSE;    
}
 
 
void CrashHandler::userCrash() {
  DataGenerator* generator=genericPlayer->getDataGenerator();
  cout << "reading generator:"<<generator<<endl;
  DecoderID* decoderID=generator->getDecoderId();
  cout << "reading decoderID:"<<decoderID<<endl;
  cout << "creating new player"<<endl;
  GenericPlayer* tmp=Amplifier::createPlayer(decoderID);
  // now we can safley delete the genericPlayer
  // it own the decoderID !
  cout << "deleteing old"<<endl;
  delete genericPlayer;
  
  genericPlayer=tmp;
  
  genericPlayer->addListener(audioDevice);
  genericPlayer->open(file);
  // reinstall slots:
  connect(genericPlayer->getEventQueue(),
	  SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
}
