/*
  prompts for an open file and opens it. Test for realtime handling
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __OPENTEST_H
#define __OPENTEST_H


#include <kapp.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <qlayout.h> 
#include <qlineedit.h>
#include <devices/genericPlayer.h>



class OpenTest : public QWidget {
 Q_OBJECT

   QBoxLayout* layout;
   QLineEdit*  lineEdit;
   QPushButton* openButton;
   GenericPlayer* genericPlayer;
  
 public:
  OpenTest( QWidget *parent=0, const char *name=0 );
  ~OpenTest();
  QSize sizeHint() const;
  void buildGui();
  void setText(const char* text);

 public slots:
  int open();

  void attachTo(GenericPlayer* genericPlayer);
  void detach();

};


#endif
