/*
  mixes a DeviceConfigArray and delivers the result to the listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <videoMixerDevice.h>



VideoMixerDevice::VideoMixerDevice() {
  VideoInfo* videoInfo;

  dest=new QPixmap();

  config=new DeviceConfig();
  VideoStream* videoStream=config->getVideoStream();
  videoInfo=videoStream->getVideoInfo();
  videoInfo->setPixmap(dest);


  videoMixerFilter=new VideoMixerFilter();

}


VideoMixerDevice::~VideoMixerDevice() {
  delete dest;
  delete videoMixerFilter;
  delete config;

}


void VideoMixerDevice::writeOut(DeviceConfigArray* buf) {

  
  videoMixerFilter->transform(buf,config);

  deliverToListener(config);
}


  
