/*
  mixes muliple configs to one
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <videoMixerFilter.h>


VideoMixerFilter::VideoMixerFilter() {
  destWidth=100;
  destHeight=100;
}


VideoMixerFilter::~VideoMixerFilter() {
}


void VideoMixerFilter::transform(DeviceConfigArray* input,
				 DeviceConfig* output) {
  
 VideoInfo* outVideoInfo;
  VideoInfo* inVideoInfo;
  QPixmap* inPixmap;
  QPixmap* outPixmap;
  VideoStream* videoStream;
  VideoStream* outVideoStream=output->getVideoStream();
  
  outVideoInfo=outVideoStream->getVideoInfo();
  
  outPixmap=outVideoInfo->getPixmap();
  if ( (outPixmap->width() != destWidth) ||
       (outPixmap->height() != destWidth) ) {
    outPixmap->resize(destWidth,destHeight);
    cout << "outPixmap resize"<<endl;
  }

  int entries=input->getEntries();
  if (entries == 0) {
    return;
  }
  int yStep=destHeight/entries;
  // in input we have the Array of pixmaps to mix
  // The output contains only one Pixmap
  // We make the mixing example simple:

  // The output Pixmap has fixed size and if we have 3 inputs to
  // mix we show a part of each in the output pixmap
  outPixmap->fill();
  DeviceConfig* current;
  int i;

  for(i=0;i<entries;i++) {
    current=input->getDeviceConfigAt(i);
    videoStream=current->getVideoStream();
    inVideoInfo=videoStream->getVideoInfo();
    inPixmap=inVideoInfo->getPixmap();
    if (inPixmap == NULL) {
      cout << "inPixmap NULL ignored"<<endl;
      continue;
    }
    bitBlt(outPixmap,0,yStep*i,inPixmap,0,0,destWidth,yStep);
  }

 

}  
