
#include <qapp.h>
#include <amplifier/amplifier.h>
#include <devices/mixerDevice.h>
#include <devices/audioDevice.h>
#include <deviceConfig/mem/garbageCollector.h>

#include <unistd.h>


/**
   This example starts two decoders adds a mixer and an
   audiodevice to it. 

   Make sure youe have edited the file

   ../SONGS.DEF


*/







int main(int nargs,char** args) {


  GarbageCollector::init();
  QApplication a( nargs, args);

  GenericPlayer* player1;
  GenericPlayer* player2;
  AudioDevice* audioDevice=new AudioDevice("/dev/dsp");
  MixerDevice* mixerDevice=new MixerDevice();

  mixerDevice->addListener(audioDevice);
  audioDevice->open();


  player1=Amplifier::createPlayer(_MPEG_VIDEO_DECODER);
  player2=Amplifier::createPlayer(_MPEG_VIDEO_DECODER);
  
  if (nargs <= 2) {
    printf("Usage:\n\n");
    printf("%s filename1.mpeg filename2.mpeg \n\n",args[0]);
    exit(0);
  }

  cout << "open file:"<<args[1]<<endl;

  player1->addListener(mixerDevice);
  player2->addListener(mixerDevice);

  
  player1->open(args[1]);
  player2->open(args[2]);
  

  // do nothing loop
  a.exec();

  delete player1;
  delete player2;

 
  return 0;
}



  
